/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.management.dto.SlowOperationDTO;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationexecutor.classic.ClassicOperationExecutor;
import com.hazelcast.spi.impl.operationexecutor.slowoperationdetector.SlowOperationDetector;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.impl.operationservice.impl.BackpressureRegulator;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationBuilderImpl;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.spi.impl.operationservice.impl.InvokeOnPartitions;
import com.hazelcast.spi.impl.operationservice.impl.IsStillRunningService;
import com.hazelcast.spi.impl.operationservice.impl.OperationBackupHandler;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerFactoryImpl;
import com.hazelcast.spi.impl.operationservice.impl.PartitionInvocation;
import com.hazelcast.spi.impl.operationservice.impl.ResponsePacketHandlerImpl;
import com.hazelcast.spi.impl.operationservice.impl.TargetInvocation;
import com.hazelcast.spi.impl.operationservice.impl.responses.Response;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.executor.ExecutorType;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class OperationServiceImpl
implements InternalOperationService {
    private static final int CORE_SIZE_CHECK = 8;
    private static final int CORE_SIZE_FACTOR = 4;
    private static final int CONCURRENCY_LEVEL = 16;
    private static final int ASYNC_QUEUE_CAPACITY = 100000;
    private static final long TERMINATION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    final InvocationRegistry invocationsRegistry;
    final OperationExecutor operationExecutor;
    final ILogger invocationLogger;
    final ManagedExecutorService asyncExecutor;
    final AtomicLong executedOperationsCount = new AtomicLong();
    final NodeEngineImpl nodeEngine;
    final Node node;
    final ILogger logger;
    final OperationBackupHandler operationBackupHandler;
    final BackpressureRegulator backpressureRegulator;
    final long defaultCallTimeoutMillis;
    private final SlowOperationDetector slowOperationDetector;
    private final IsStillRunningService isStillRunningService;

    public OperationServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.node = nodeEngine.getNode();
        this.logger = this.node.getLogger(OperationService.class);
        this.invocationLogger = nodeEngine.getLogger(Invocation.class);
        GroupProperties groupProperties = this.node.getGroupProperties();
        this.defaultCallTimeoutMillis = groupProperties.OPERATION_CALL_TIMEOUT_MILLIS.getLong();
        this.backpressureRegulator = new BackpressureRegulator(groupProperties, this.logger);
        int coreSize = Runtime.getRuntime().availableProcessors();
        boolean reallyMultiCore = coreSize >= 8;
        int concurrencyLevel = reallyMultiCore ? coreSize * 4 : 16;
        this.invocationsRegistry = new InvocationRegistry(this, concurrencyLevel);
        this.operationBackupHandler = new OperationBackupHandler(this);
        this.operationExecutor = new ClassicOperationExecutor(groupProperties, this.node.loggingService, this.node.getThisAddress(), new OperationRunnerFactoryImpl(this), new ResponsePacketHandlerImpl(this), this.node.getHazelcastThreadGroup(), this.node.getNodeExtension());
        this.isStillRunningService = new IsStillRunningService(this.operationExecutor, nodeEngine, this.logger);
        InternalExecutionService executionService = nodeEngine.getExecutionService();
        this.asyncExecutor = executionService.register("hz:async", coreSize, 100000, ExecutorType.CONCRETE);
        this.slowOperationDetector = this.initSlowOperationDetector();
    }

    private SlowOperationDetector initSlowOperationDetector() {
        return new SlowOperationDetector(this.node.loggingService, this.operationExecutor.getGenericOperationRunners(), this.operationExecutor.getPartitionOperationRunners(), this.node.groupProperties, this.node.getHazelcastThreadGroup());
    }

    public IsStillRunningService getIsStillRunningService() {
        return this.isStillRunningService;
    }

    @Override
    public void dumpPerformanceMetrics(StringBuffer sb) {
        sb.append("invocationsPending=").append(this.invocationsRegistry.getInvocationUsagePercentage()).append('\n');
        sb.append("invocationsUsed=").append(String.format("%.2f", this.invocationsRegistry.getInvocationUsagePercentage())).append("%\n");
        sb.append("invocationsMax=").append(this.backpressureRegulator.getMaxConcurrentInvocations()).append('\n');
        this.operationExecutor.dumpPerformanceMetrics(sb);
    }

    @Override
    public List<SlowOperationDTO> getSlowOperationDTOs() {
        return this.slowOperationDetector.getSlowOperationDTOs();
    }

    public InvocationRegistry getInvocationsRegistry() {
        return this.invocationsRegistry;
    }

    @Override
    public int getPendingInvocationCount() {
        return this.invocationsRegistry.size();
    }

    @Override
    public double getInvocationUsagePercentage() {
        return this.invocationsRegistry.getInvocationUsagePercentage();
    }

    @Override
    public int getPartitionOperationThreadCount() {
        return this.operationExecutor.getPartitionOperationThreadCount();
    }

    @Override
    public int getGenericOperationThreadCount() {
        return this.operationExecutor.getGenericOperationThreadCount();
    }

    @Override
    public int getRunningOperationsCount() {
        return this.operationExecutor.getRunningOperationCount();
    }

    @Override
    public long getExecutedOperationCount() {
        return this.executedOperationsCount.get();
    }

    @Override
    public int getRemoteOperationsCount() {
        return this.invocationsRegistry.size();
    }

    @Override
    public int getResponseQueueSize() {
        return this.operationExecutor.getResponseQueueSize();
    }

    @Override
    public int getOperationExecutorQueueSize() {
        return this.operationExecutor.getOperationExecutorQueueSize();
    }

    @Override
    public int getPriorityOperationExecutorQueueSize() {
        return this.operationExecutor.getPriorityOperationExecutorQueueSize();
    }

    @Override
    public OperationExecutor getOperationExecutor() {
        return this.operationExecutor;
    }

    @Override
    public void execute(PartitionSpecificRunnable task) {
        this.operationExecutor.execute(task);
    }

    @Override
    public InvocationBuilder createInvocationBuilder(String serviceName, Operation op, int partitionId) {
        if (partitionId < 0) {
            throw new IllegalArgumentException("Partition id cannot be negative!");
        }
        return new InvocationBuilderImpl(this.nodeEngine, serviceName, op, partitionId);
    }

    @Override
    public InvocationBuilder createInvocationBuilder(String serviceName, Operation op, Address target) {
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null!");
        }
        return new InvocationBuilderImpl(this.nodeEngine, serviceName, op, target);
    }

    @Override
    public void runOperationOnCallingThread(Operation op) {
        this.operationExecutor.runOnCallingThread(op);
    }

    @Override
    public void executeOperation(Operation op) {
        this.operationExecutor.execute(op);
    }

    @Override
    public boolean isAllowedToRunOnCallingThread(Operation op) {
        return this.operationExecutor.isAllowedToRunInCurrentThread(op);
    }

    @Override
    public <E> InternalCompletableFuture<E> invokeOnPartition(String serviceName, Operation op, int partitionId) {
        return new PartitionInvocation(this.nodeEngine, serviceName, op, partitionId, 0, 250, 500L, -1L, null, true).invoke();
    }

    @Override
    public <E> InternalCompletableFuture<E> invokeOnTarget(String serviceName, Operation op, Address target) {
        return new TargetInvocation(this.nodeEngine, serviceName, op, target, 250, 500L, -1L, null, true).invoke();
    }

    @Override
    public <V> void asyncInvokeOnPartition(String serviceName, Operation op, int partitionId, ExecutionCallback<V> callback) {
        new PartitionInvocation(this.nodeEngine, serviceName, op, partitionId, 0, 250, 500L, -1L, callback, true).invokeAsync();
    }

    @Override
    public <V> void asyncInvokeOnTarget(String serviceName, Operation op, Address target, ExecutionCallback<V> callback) {
        new TargetInvocation(this.nodeEngine, serviceName, op, target, 250, 500L, -1L, callback, true).invokeAsync();
    }

    @Override
    public boolean isCallTimedOut(Operation op) {
        if (!op.returnsResponse() || op.getCallId() == 0L) {
            return false;
        }
        long callTimeout = op.getCallTimeout();
        long invocationTime = op.getInvocationTime();
        long expireTime = invocationTime + callTimeout;
        if (expireTime <= 0L || expireTime >= Long.MAX_VALUE) {
            return false;
        }
        long now = this.nodeEngine.getClusterService().getClusterClock().getClusterTime();
        return expireTime < now;
    }

    @Override
    public Map<Integer, Object> invokeOnAllPartitions(String serviceName, OperationFactory operationFactory) throws Exception {
        Map<Address, List<Integer>> memberPartitions = this.nodeEngine.getPartitionService().getMemberPartitionsMap();
        InvokeOnPartitions invokeOnPartitions = new InvokeOnPartitions(this, serviceName, operationFactory, memberPartitions);
        return invokeOnPartitions.invoke();
    }

    @Override
    public Map<Integer, Object> invokeOnPartitions(String serviceName, OperationFactory operationFactory, Collection<Integer> partitions) throws Exception {
        HashMap<Address, List<Integer>> memberPartitions = new HashMap<Address, List<Integer>>(3);
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        for (int partition : partitions) {
            Address owner = partitionService.getPartitionOwnerOrWait(partition);
            if (!memberPartitions.containsKey(owner)) {
                memberPartitions.put(owner, new ArrayList());
            }
            ((List)memberPartitions.get(owner)).add(partition);
        }
        InvokeOnPartitions invokeOnPartitions = new InvokeOnPartitions(this, serviceName, operationFactory, memberPartitions);
        return invokeOnPartitions.invoke();
    }

    @Override
    public boolean send(Operation op, Address target) {
        if (target == null) {
            throw new IllegalArgumentException("Target is required!");
        }
        if (this.nodeEngine.getThisAddress().equals(target)) {
            throw new IllegalArgumentException("Target is this node! -> " + target + ", op: " + op);
        }
        Data data = this.nodeEngine.toData(op);
        int partitionId = op.getPartitionId();
        Packet packet = new Packet(data, partitionId);
        packet.setHeader(0);
        if (op instanceof UrgentSystemOperation) {
            packet.setHeader(4);
        }
        Connection connection = this.node.getConnectionManager().getOrConnect(target);
        return this.nodeEngine.getPacketTransceiver().transmit(packet, connection);
    }

    @Override
    public boolean send(Response response, Address target) {
        if (target == null) {
            throw new IllegalArgumentException("Target is required!");
        }
        if (this.nodeEngine.getThisAddress().equals(target)) {
            throw new IllegalArgumentException("Target is this node! -> " + target + ", response: " + response);
        }
        Data data = this.nodeEngine.toData(response);
        Packet packet = new Packet(data);
        packet.setHeader(0);
        packet.setHeader(1);
        if (response.isUrgent()) {
            packet.setHeader(4);
        }
        Connection connection = this.node.getConnectionManager().getOrConnect(target);
        return this.nodeEngine.getPacketTransceiver().transmit(packet, connection);
    }

    public void onMemberLeft(MemberImpl member) {
        this.invocationsRegistry.onMemberLeft(member);
    }

    public void reset() {
        this.invocationsRegistry.reset();
    }

    public void shutdown() {
        this.logger.finest("Shutting down OperationService");
        this.invocationsRegistry.shutdown();
        this.operationExecutor.shutdown();
        this.slowOperationDetector.shutdown();
        try {
            this.invocationsRegistry.awaitTermination(TERMINATION_TIMEOUT_MILLIS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            EmptyStatement.ignore(e);
        }
    }
}

