/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collection;

final class ClearReplicaOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    private final int oldReplicaIndex;

    public ClearReplicaOperation(int oldReplicaIndex) {
        this.oldReplicaIndex = oldReplicaIndex;
    }

    @Override
    public void run() throws Exception {
        Address thisAddress;
        int partitionId = this.getPartitionId();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        InternalPartitionImpl partition = partitionService.getPartitionImpl(partitionId);
        int currentReplicaIndex = partition.getReplicaIndex(thisAddress = this.getNodeEngine().getThisAddress());
        if (currentReplicaIndex == -1 || currentReplicaIndex > this.oldReplicaIndex) {
            ILogger logger;
            if (currentReplicaIndex == -1) {
                partitionService.cancelReplicaSync(partitionId);
            }
            if ((logger = this.getLogger()).isFinestEnabled()) {
                logger.finest("Clearing partition replica... partitionId=" + partitionId + ", old-replicaIndex=" + this.oldReplicaIndex + ", current-replicaIndex=" + currentReplicaIndex);
            }
            this.clearPartition(partitionId, partitionService);
        }
    }

    private void clearPartition(int partitionId, InternalPartitionServiceImpl partitionService) {
        NodeEngineImpl nodeEngine = partitionService.getNode().getNodeEngine();
        Collection<MigrationAwareService> services = nodeEngine.getServices(MigrationAwareService.class);
        for (MigrationAwareService service : services) {
            try {
                service.clearPartitionReplica(partitionId);
            }
            catch (Throwable e) {
                this.logMigrationError(e);
            }
        }
        partitionService.clearPartitionReplicaVersions(partitionId);
    }

    private void logMigrationError(Throwable e) {
        ILogger logger = this.getLogger();
        logger.warning("Error while clearing data. partitionId=" + this.getPartitionId() + " old-replicaIndex=" + this.oldReplicaIndex, e);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

