/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.type.BasicSqlType;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HazelcastIntegerType
extends BasicSqlType {
    private static final Map<SqlTypeName, HazelcastIntegerType[]> TYPES = new HashMap<SqlTypeName, HazelcastIntegerType[]>();
    private static final Map<SqlTypeName, HazelcastIntegerType[]> NULLABLE_TYPES = new HashMap<SqlTypeName, HazelcastIntegerType[]>();
    private static final HazelcastIntegerType[] TYPES_BY_BIT_WIDTH;
    private static final HazelcastIntegerType[] NULLABLE_TYPES_BY_BIT_WIDTH;
    private final int bitWidth;

    private HazelcastIntegerType(SqlTypeName typeName, boolean nullable, int bitWidth) {
        super(HazelcastTypeSystem.INSTANCE, typeName);
        this.isNullable = nullable;
        assert (bitWidth >= 0 && bitWidth <= HazelcastIntegerType.overflowBitWidthOf(typeName));
        this.bitWidth = bitWidth;
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        super.generateTypeString(sb, withDetail);
        if (withDetail) {
            sb.append('(').append(this.bitWidth).append(')');
        }
    }

    public static HazelcastIntegerType of(SqlTypeName typeName) {
        assert (HazelcastIntegerType.supports(typeName));
        return TYPES.get((Object)typeName)[HazelcastIntegerType.bitWidthOf(typeName)];
    }

    public static HazelcastIntegerType of(SqlTypeName typeName, boolean nullable) {
        assert (HazelcastIntegerType.supports(typeName));
        if (nullable) {
            return NULLABLE_TYPES.get((Object)typeName)[HazelcastIntegerType.bitWidthOf(typeName)];
        }
        return TYPES.get((Object)typeName)[HazelcastIntegerType.bitWidthOf(typeName)];
    }

    public static RelDataType of(RelDataType type, boolean nullable) {
        SqlTypeName typeName = type.getSqlTypeName();
        assert (HazelcastIntegerType.supports(typeName));
        if (type.isNullable() == nullable) {
            return type;
        }
        return HazelcastIntegerType.of(typeName, nullable, HazelcastIntegerType.bitWidthOf(type));
    }

    public static HazelcastIntegerType of(int bitWidth, boolean nullable) {
        assert (bitWidth >= 0);
        if (nullable) {
            return bitWidth > 64 ? NULLABLE_TYPES_BY_BIT_WIDTH[64] : NULLABLE_TYPES_BY_BIT_WIDTH[bitWidth];
        }
        return bitWidth > 64 ? TYPES_BY_BIT_WIDTH[64] : TYPES_BY_BIT_WIDTH[bitWidth];
    }

    public static boolean supports(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public static int bitWidthOf(long value) {
        if (value == Long.MIN_VALUE) {
            return 63;
        }
        if (value == Integer.MIN_VALUE) {
            return 31;
        }
        if (value == -32768L) {
            return 15;
        }
        if (value == -128L) {
            return 7;
        }
        value = Math.abs(value);
        return 64 - Long.numberOfLeadingZeros(value);
    }

    public static int noOverflowBitWidthOf(RelDataType type) {
        assert (HazelcastIntegerType.supports(type.getSqlTypeName()));
        HazelcastIntegerType integerType = (HazelcastIntegerType)type;
        return Math.min(integerType.bitWidth, HazelcastIntegerType.bitWidthOf(type.getSqlTypeName()));
    }

    public static RelDataType deriveLiteralType(SqlLiteral literal) {
        long value;
        try {
            value = literal.bigDecimalValue().longValueExact();
        }
        catch (ArithmeticException e) {
            return HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.BIGINT);
        }
        return HazelcastIntegerType.of(HazelcastIntegerType.bitWidthOf(value), false);
    }

    public static RelDataType deriveCastType(RelDataType fromType, RelDataType toType) {
        int toBitWidth;
        SqlTypeName fromTypeName = fromType.getSqlTypeName();
        assert (HazelcastIntegerType.supports(fromTypeName));
        SqlTypeName toTypeName = toType.getSqlTypeName();
        assert (HazelcastIntegerType.supports(toTypeName));
        int fromBitWidth = HazelcastIntegerType.bitWidthOf(fromType);
        if (fromBitWidth < (toBitWidth = HazelcastIntegerType.bitWidthOf(toType))) {
            return HazelcastIntegerType.of(toTypeName, toType.isNullable(), fromBitWidth);
        }
        if (fromBitWidth > toBitWidth) {
            int expandedBitWidth = fromBitWidth == HazelcastIntegerType.overflowBitWidthOf(fromTypeName) ? HazelcastIntegerType.overflowBitWidthOf(toTypeName) : Math.min(fromBitWidth, HazelcastIntegerType.overflowBitWidthOf(toTypeName));
            return HazelcastIntegerType.of(toTypeName, toType.isNullable(), expandedBitWidth);
        }
        return toType;
    }

    public static RelDataType deriveCastType(long value, RelDataType toType) {
        int typeBitWidth;
        SqlTypeName toTypeName = toType.getSqlTypeName();
        assert (HazelcastIntegerType.supports(toTypeName));
        int valueBitWidth = HazelcastIntegerType.bitWidthOf(value);
        if (valueBitWidth > (typeBitWidth = HazelcastIntegerType.bitWidthOf(toTypeName))) {
            return HazelcastIntegerType.of(toTypeName, toType.isNullable(), HazelcastIntegerType.overflowBitWidthOf(toTypeName));
        }
        return HazelcastIntegerType.of(toTypeName, toType.isNullable(), valueBitWidth);
    }

    public static RelDataType leastRestrictive(RelDataType targetType, List<RelDataType> types) {
        SqlTypeName typeName = targetType.getSqlTypeName();
        assert (HazelcastIntegerType.supports(typeName));
        int maxBitWidth = -1;
        RelDataType maxBitWidthType = null;
        for (RelDataType type : types) {
            int bitWidth;
            if (type.getSqlTypeName() != typeName || (bitWidth = HazelcastIntegerType.bitWidthOf(type)) <= maxBitWidth) continue;
            maxBitWidth = bitWidth;
            maxBitWidthType = type;
        }
        assert (maxBitWidthType != null);
        assert (maxBitWidthType.getSqlTypeName() == typeName);
        return HazelcastIntegerType.of(maxBitWidthType, targetType.isNullable());
    }

    public static int bitWidthOf(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: {
                return 7;
            }
            case SMALLINT: {
                return 15;
            }
            case INTEGER: {
                return 31;
            }
            case BIGINT: {
                return 63;
            }
        }
        throw new IllegalArgumentException("unexpected type: " + (Object)((Object)typeName));
    }

    public static int bitWidthOf(RelDataType type) {
        assert (HazelcastIntegerType.supports(type.getSqlTypeName()));
        return ((HazelcastIntegerType)type).bitWidth;
    }

    public static boolean canOverflow(RelDataType type) {
        assert (type instanceof HazelcastIntegerType);
        HazelcastIntegerType integerType = (HazelcastIntegerType)type;
        int overflowBitWidth = HazelcastIntegerType.overflowBitWidthOf(integerType.getSqlTypeName());
        assert (integerType.bitWidth >= 0 && integerType.bitWidth <= overflowBitWidth);
        return integerType.bitWidth == overflowBitWidth;
    }

    private static HazelcastIntegerType of(SqlTypeName typeName, boolean nullable, int bitWidth) {
        assert (bitWidth >= 0 && bitWidth <= HazelcastIntegerType.overflowBitWidthOf(typeName));
        if (nullable) {
            return NULLABLE_TYPES.get((Object)typeName)[bitWidth];
        }
        return TYPES.get((Object)typeName)[bitWidth];
    }

    private static int overflowBitWidthOf(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: {
                return 8;
            }
            case SMALLINT: {
                return 16;
            }
            case INTEGER: {
                return 32;
            }
            case BIGINT: {
                return 64;
            }
        }
        throw new IllegalArgumentException("unexpected type: " + (Object)((Object)typeName));
    }

    static {
        TYPES.put(SqlTypeName.TINYINT, new HazelcastIntegerType[9]);
        TYPES.put(SqlTypeName.SMALLINT, new HazelcastIntegerType[17]);
        TYPES.put(SqlTypeName.INTEGER, new HazelcastIntegerType[33]);
        TYPES.put(SqlTypeName.BIGINT, new HazelcastIntegerType[65]);
        for (Map.Entry<SqlTypeName, HazelcastIntegerType[]> entry : TYPES.entrySet()) {
            SqlTypeName typeName = entry.getKey();
            HazelcastIntegerType[] types = entry.getValue();
            HazelcastIntegerType[] nullableTypes = new HazelcastIntegerType[types.length];
            NULLABLE_TYPES.put(typeName, nullableTypes);
            for (int i = 0; i < types.length; ++i) {
                types[i] = new HazelcastIntegerType(typeName, false, i);
                nullableTypes[i] = new HazelcastIntegerType(typeName, true, i);
            }
        }
        TYPES_BY_BIT_WIDTH = new HazelcastIntegerType[65];
        NULLABLE_TYPES_BY_BIT_WIDTH = new HazelcastIntegerType[65];
        for (int i = 0; i <= 64; ++i) {
            HazelcastIntegerType nullableType;
            HazelcastIntegerType type;
            if (i < 8) {
                type = TYPES.get((Object)SqlTypeName.TINYINT)[i];
                nullableType = NULLABLE_TYPES.get((Object)SqlTypeName.TINYINT)[i];
            } else if (i < 16) {
                type = TYPES.get((Object)SqlTypeName.SMALLINT)[i];
                nullableType = NULLABLE_TYPES.get((Object)SqlTypeName.SMALLINT)[i];
            } else if (i < 32) {
                type = TYPES.get((Object)SqlTypeName.INTEGER)[i];
                nullableType = NULLABLE_TYPES.get((Object)SqlTypeName.INTEGER)[i];
            } else {
                type = TYPES.get((Object)SqlTypeName.BIGINT)[i];
                nullableType = NULLABLE_TYPES.get((Object)SqlTypeName.BIGINT)[i];
            }
            HazelcastIntegerType.TYPES_BY_BIT_WIDTH[i] = type;
            HazelcastIntegerType.NULLABLE_TYPES_BY_BIT_WIDTH[i] = nullableType;
        }
    }
}

