/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;

public final class FilterRemoveIsNotDistinctFromRule
extends RelOptRule
implements TransformationRule {
    public static final FilterRemoveIsNotDistinctFromRule INSTANCE = new FilterRemoveIsNotDistinctFromRule(RelFactories.LOGICAL_BUILDER);

    public FilterRemoveIsNotDistinctFromRule(RelBuilderFactory relBuilderFactory) {
        super(FilterRemoveIsNotDistinctFromRule.operand(Filter.class, FilterRemoveIsNotDistinctFromRule.any()), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter oldFilter = (Filter)call.rel(0);
        RexNode oldFilterCond = oldFilter.getCondition();
        if (RexUtil.findOperatorCall(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, oldFilterCond) == null) {
            return;
        }
        RemoveIsNotDistinctFromRexShuttle rewriteShuttle = new RemoveIsNotDistinctFromRexShuttle(oldFilter.getCluster().getRexBuilder());
        RelBuilder relBuilder = call.builder();
        RelNode newFilterRel = relBuilder.push(oldFilter.getInput()).filter(oldFilterCond.accept(rewriteShuttle)).build();
        call.transformTo(newFilterRel);
    }

    private class RemoveIsNotDistinctFromRexShuttle
    extends RexShuttle {
        RexBuilder rexBuilder;

        RemoveIsNotDistinctFromRexShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode newCall = super.visitCall(call);
            if (call.getOperator() == SqlStdOperatorTable.IS_NOT_DISTINCT_FROM) {
                RexCall tmpCall = (RexCall)newCall;
                newCall = RelOptUtil.isDistinctFrom(this.rexBuilder, (RexNode)tmpCall.operands.get(0), (RexNode)tmpCall.operands.get(1), true);
            }
            return newCall;
        }
    }
}

