/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.partition.FragmentedMigrationAwareService;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.MapReplicationOperation;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.publisher.AccumulatorSweeper;
import com.hazelcast.map.impl.querycache.publisher.PublisherContext;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.RecordStoreAdapter;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.Collection;
import java.util.function.Predicate;

class MapMigrationAwareService
implements FragmentedMigrationAwareService {
    protected final PartitionContainer[] containers;
    protected final MapServiceContext mapServiceContext;
    protected final SerializationService serializationService;
    private final ILogger logger;

    MapMigrationAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.serializationService = mapServiceContext.getNodeEngine().getSerializationService();
        this.containers = mapServiceContext.getPartitionContainers();
        this.logger = mapServiceContext.getNodeEngine().getLogger(this.getClass());
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        return this.containers[event.getPartitionId()].getAllNamespaces(event.getReplicaIndex());
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        return namespace instanceof ObjectNamespace && "hz:impl:mapService".equals(namespace.getServiceName());
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        if (MapMigrationAwareService.isLocalPromotion(event)) {
            this.clearNonGlobalIndexes(event);
            this.populateIndexes(event, TargetIndexes.NON_GLOBAL, "beforeMigration");
        }
        this.flushAndRemoveQueryCaches(event);
    }

    private void flushAndRemoveQueryCaches(PartitionMigrationEvent event) {
        int partitionId = event.getPartitionId();
        QueryCacheContext queryCacheContext = this.mapServiceContext.getQueryCacheContext();
        PublisherContext publisherContext = queryCacheContext.getPublisherContext();
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            AccumulatorSweeper.flushAccumulator(publisherContext, partitionId);
            AccumulatorSweeper.removeAccumulator(publisherContext, partitionId);
            return;
        }
        if (MapMigrationAwareService.isLocalPromotion(event)) {
            AccumulatorSweeper.removeAccumulator(publisherContext, partitionId);
            AccumulatorSweeper.sendEndOfSequenceEvents(publisherContext, partitionId);
            return;
        }
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.prepareReplicationOperation(event, this.containers[event.getPartitionId()].getAllNamespaces(event.getReplicaIndex()));
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        assert (this.assertAllKnownNamespaces(namespaces));
        int partitionId = event.getPartitionId();
        MapReplicationOperation operation = new MapReplicationOperation(this.containers[partitionId], namespaces, partitionId, event.getReplicaIndex());
        operation.setService(this.mapServiceContext.getService());
        operation.setNodeEngine(this.mapServiceContext.getNodeEngine());
        return operation;
    }

    private boolean assertAllKnownNamespaces(Collection<ServiceNamespace> namespaces) {
        for (ServiceNamespace namespace : namespaces) {
            assert (this.isKnownServiceNamespace(namespace)) : namespace + " is not a MapService namespace!";
        }
        return true;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.populateIndexes(event, TargetIndexes.GLOBAL, "commitMigration");
        } else {
            this.depopulateIndexes(event, "commitMigration");
        }
        if (MigrationEndpoint.SOURCE == event.getMigrationEndpoint()) {
            this.removeWbqCountersHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
            this.removeRecordStoresHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : partitionContainer.getAllRecordStores()) {
            recordStore.startLoading();
        }
        this.mapServiceContext.nullifyOwnedPartitions();
        this.removeOrRegenerateNearCacheUuid(event);
    }

    private void removeOrRegenerateNearCacheUuid(PartitionMigrationEvent event) {
        if (MigrationEndpoint.SOURCE == event.getMigrationEndpoint()) {
            this.getMetaDataGenerator().removeUuidAndSequence(event.getPartitionId());
            return;
        }
        if (MigrationEndpoint.DESTINATION == event.getMigrationEndpoint() && event.getNewReplicaIndex() != 0) {
            this.getMetaDataGenerator().regenerateUuid(event.getPartitionId());
            return;
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (MigrationEndpoint.DESTINATION == event.getMigrationEndpoint()) {
            this.removeWbqCountersHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
            this.removeRecordStoresHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
            this.getMetaDataGenerator().removeUuidAndSequence(event.getPartitionId());
        }
        this.mapServiceContext.nullifyOwnedPartitions();
    }

    private void clearNonGlobalIndexes(PartitionMigrationEvent event) {
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : container.getMaps().values()) {
            MapContainer mapContainer = this.mapServiceContext.getMapContainer(recordStore.getName());
            Indexes indexes = mapContainer.getIndexes(event.getPartitionId());
            if (!indexes.haveAtLeastOneIndex() || indexes.isGlobal()) continue;
            indexes.clearAll();
        }
    }

    private void removeRecordStoresHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        if (thresholdReplicaIndex < 0) {
            this.mapServiceContext.removeRecordStoresFromPartitionMatchingWith(recordStore -> true, partitionId, false, true);
        } else {
            this.mapServiceContext.removeRecordStoresFromPartitionMatchingWith(MapMigrationAwareService.lesserBackupMapsThen(thresholdReplicaIndex), partitionId, false, true);
        }
    }

    private void removeWbqCountersHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        if (thresholdReplicaIndex < 0) {
            this.mapServiceContext.removeWbqCountersFromMatchingPartitionsWith(recordStore -> true, partitionId);
        } else {
            this.mapServiceContext.removeWbqCountersFromMatchingPartitionsWith(MapMigrationAwareService.lesserBackupMapsThen(thresholdReplicaIndex), partitionId);
        }
    }

    private static Predicate<RecordStore> lesserBackupMapsThen(int backupCount) {
        return recordStore -> recordStore.getMapContainer().getTotalBackupCount() < backupCount;
    }

    private MetaDataGenerator getMetaDataGenerator() {
        return this.mapServiceContext.getMapNearCacheManager().getInvalidator().getMetaDataGenerator();
    }

    private void populateIndexes(PartitionMigrationEvent event, TargetIndexes targetIndexes, String stepName) {
        assert (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION);
        assert (targetIndexes != null);
        if (event.getNewReplicaIndex() != 0) {
            return;
        }
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : container.getMaps().values()) {
            MapContainer mapContainer = this.mapServiceContext.getMapContainer(recordStore.getName());
            RecordStoreAdapter storeAdapter = new RecordStoreAdapter(recordStore);
            Indexes indexes = mapContainer.getIndexes(event.getPartitionId());
            indexes.createIndexesFromRecordedDefinitions(storeAdapter);
            if (!indexes.haveAtLeastOneIndex() || indexes.isGlobal() && targetIndexes == TargetIndexes.NON_GLOBAL || !indexes.isGlobal() && targetIndexes == TargetIndexes.GLOBAL) continue;
            InternalIndex[] indexesSnapshot = indexes.getIndexes();
            Indexes.beginPartitionUpdate(indexesSnapshot);
            recordStore.forEach((key, record) -> {
                Object value = Records.getValueOrCachedValue(record, this.serializationService);
                if (value != null) {
                    QueryableEntry queryEntry = mapContainer.newQueryEntry((Data)key, value);
                    queryEntry.setRecord((Record)record);
                    queryEntry.setStoreAdapter(storeAdapter);
                    indexes.putEntry(queryEntry, null, Index.OperationSource.SYSTEM);
                }
            }, false);
            Indexes.markPartitionAsIndexed(event.getPartitionId(), indexesSnapshot);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Populated indexes at step `%s`:[%s]", stepName, event));
        }
    }

    private void depopulateIndexes(PartitionMigrationEvent event, String stepName) {
        assert (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE);
        assert (event.getNewReplicaIndex() != 0) : "Invalid migration event: " + event;
        if (event.getCurrentReplicaIndex() != 0) {
            return;
        }
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : container.getMaps().values()) {
            MapContainer mapContainer = this.mapServiceContext.getMapContainer(recordStore.getName());
            Indexes indexes = mapContainer.getIndexes(event.getPartitionId());
            if (!indexes.haveAtLeastOneIndex()) continue;
            InternalIndex[] indexesSnapshot = indexes.getIndexes();
            Indexes.beginPartitionUpdate(indexesSnapshot);
            recordStore.forEach((key, record) -> {
                Object value = Records.getValueOrCachedValue(record, this.serializationService);
                indexes.removeEntry((Data)key, value, Index.OperationSource.SYSTEM);
            }, false);
            Indexes.markPartitionAsUnindexed(event.getPartitionId(), indexesSnapshot);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Depopulated indexes at step `%s`:[%s]", stepName, event));
        }
    }

    private static boolean isLocalPromotion(PartitionMigrationEvent event) {
        return event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION && event.getCurrentReplicaIndex() > 0 && event.getNewReplicaIndex() == 0;
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }

    private static enum TargetIndexes {
        GLOBAL,
        NON_GLOBAL;

    }
}

