/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.sql.SqlColumnMetadata;

public final class SqlColumnMetadataCodec {
    private static final int TYPE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private SqlColumnMetadataCodec() {
    }

    public static void encode(ClientMessage clientMessage, SqlColumnMetadata sqlColumnMetadata) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, sqlColumnMetadata.getType());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, sqlColumnMetadata.getName());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static SqlColumnMetadata decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int type = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String name = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createSqlColumnMetadata(name, type);
    }
}

