/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.impl;

import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class WanEventCounter {
    private static final ConstructorFunction<String, EventCounter> EVENT_COUNTER_CONSTRUCTOR_FN = new ConstructorFunction<String, EventCounter>(){

        @Override
        public EventCounter createNew(String ignored) {
            return new EventCounter();
        }
    };
    private final ConcurrentHashMap<String, EventCounter> eventCounterMap = new ConcurrentHashMap();

    public void incrementSync(String distributedObjectName) {
        ConcurrencyUtil.getOrPutIfAbsent(this.eventCounterMap, distributedObjectName, WanEventCounter.EVENT_COUNTER_CONSTRUCTOR_FN).incrementSyncCount();
    }

    public void incrementUpdate(String distributedObjectName) {
        ConcurrencyUtil.getOrPutIfAbsent(this.eventCounterMap, distributedObjectName, WanEventCounter.EVENT_COUNTER_CONSTRUCTOR_FN).incrementUpdateCount();
    }

    public void incrementRemove(String distributedObjectName) {
        ConcurrencyUtil.getOrPutIfAbsent(this.eventCounterMap, distributedObjectName, WanEventCounter.EVENT_COUNTER_CONSTRUCTOR_FN).incrementRemoveCount();
    }

    public void incrementDropped(String distributedObjectName) {
        ConcurrencyUtil.getOrPutIfAbsent(this.eventCounterMap, distributedObjectName, WanEventCounter.EVENT_COUNTER_CONSTRUCTOR_FN).incrementDroppedCount();
    }

    public void removeCounter(String dataStructureName) {
        this.eventCounterMap.remove(dataStructureName);
    }

    public ConcurrentHashMap<String, EventCounter> getEventCounterMap() {
        return this.eventCounterMap;
    }

    public static final class EventCounter {
        private final AtomicLong syncCount = new AtomicLong();
        private final AtomicLong updateCount = new AtomicLong();
        private final AtomicLong removeCount = new AtomicLong();
        private final AtomicLong droppedCount = new AtomicLong();

        private EventCounter() {
        }

        private void incrementSyncCount() {
            this.syncCount.incrementAndGet();
        }

        private void incrementUpdateCount() {
            this.updateCount.incrementAndGet();
        }

        private void incrementRemoveCount() {
            this.removeCount.incrementAndGet();
        }

        private void incrementDroppedCount() {
            this.droppedCount.incrementAndGet();
        }

        public long getDroppedCount() {
            return this.droppedCount.longValue();
        }

        public long getSyncCount() {
            return this.syncCount.longValue();
        }

        public long getUpdateCount() {
            return this.updateCount.longValue();
        }

        public long getRemoveCount() {
            return this.removeCount.longValue();
        }
    }
}

