/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.com.eclipsesource.json.Json;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.config.WANQueueFullBehavior;
import com.hazelcast.config.WanPublisherConfig;
import com.hazelcast.internal.management.JsonSerializable;
import java.util.Map;

public class WanPublisherConfigDTO
implements JsonSerializable {
    private WanPublisherConfig config;

    public WanPublisherConfigDTO(WanPublisherConfig config) {
        this.config = config;
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.add("groupName", this.config.getGroupName());
        object.add("queueCapacity", this.config.getQueueCapacity());
        object.add("className", this.config.getClassName());
        object.add("queueFullBehavior", this.config.getQueueFullBehavior().getId());
        JsonObject properties = new JsonObject();
        for (Map.Entry<String, Comparable> property : this.config.getProperties().entrySet()) {
            properties.add(property.getKey(), Json.value(property.getValue().toString()));
        }
        object.add("properties", properties);
        return object;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.config = new WanPublisherConfig();
        this.config.setGroupName(json.get("groupName").asString());
        this.config.setQueueCapacity(json.get("queueCapacity").asInt());
        this.config.setClassName(json.get("className").asString());
        int queueFullBehavior = json.get("queueFullBehavior").asInt();
        this.config.setQueueFullBehavior(WANQueueFullBehavior.getByType(queueFullBehavior));
        JsonObject properties = (JsonObject)json.get("properties");
        Map<String, Comparable> configProperties = this.config.getProperties();
        for (String propertyName : properties.names()) {
            configProperties.put(propertyName, (Comparable)((Object)properties.get(propertyName).asString()));
        }
    }

    public WanPublisherConfig getConfig() {
        return this.config;
    }
}

