define("io.ox/chat/views/chat",["io.ox/core/extensions","io.ox/chat/api","io.ox/backbone/views/disposable","io.ox/chat/views/avatar","io.ox/chat/views/chatAvatar","io.ox/chat/views/chatMember","io.ox/chat/views/messages","io.ox/chat/views/content","io.ox/chat/views/typing","io.ox/chat/events","io.ox/chat/data","io.ox/chat/util","io.ox/chat/toolbar","io.ox/core/yell","io.ox/backbone/views/toolbar","gettext!io.ox/chat","io.ox/core/strings","io.ox/core/notifications","io.ox/chat/views/dropzone"],function(e,a,t,i,o,s,n,l,d,r,h,c,m,p,g,u,f,b,v){"use strict";t=t.extend({className:"chat abs",events:{"keydown textarea":"onEditorKeydown","input textarea":"onEditorInput","click .send-btn":"onSend","click .toggle-emoji":"onToggleEmoji","click .file-upload-btn":"onTriggerFileupload","click .jump-down":"onJumpDown","change .file-upload-input":"onFileupload","click .cancel-btn":"onCancelSpecialMode"},initialize:function(e){this.roomId=e.roomId,this.messageId=e.messageId,this.model=this.model||h.chats.get(this.roomId),this.$scrollpane=$('<div class="scrollpane scrollable" tabindex="0">').lazyloadScrollpane(),this.$connectionProblemBanner=$('<div class="connection-problem-banner">').text(u("Connection problems")),this.messagesView=new n({room:this.model,collection:this.model.messages,scrollpane:this.$scrollpane}),this.listenTo(this.model,{"change:title":this.onChangeTitle,"change:favorite":this.updateDropdown,"change:unreadCount":this.onChangeUnreadCount,"change:roomId":this.onChangeRoomId,"change:members":this.onChangeMembers}),this.isMember=this.model.isMember(),this.listenTo(this.model.messages,{"after:all":this.onUpdatePaginators.bind(this),paginate:this.toggleAutoScroll.bind(this,!1)}),this.listenTo(r,{"cmd:message:delete":this.onMessageDelete,"cmd:message:edit":this.onMessageEdit,"cmd:message:reply":this.onMessageReply,"socket:disconnected":this.updateConnectionProblemBanner.bind(this),"socket:connected":this.updateConnectionProblemBanner.bind(this)}),this.listenTo(this.messagesView,{"before:add":this.onBeforeAdd,"after:add":this.onAfterAdd}),this.on("appended",function(){this.$editor.focus().trigger("input")}),this.on("dispose",this.onDispose),this.messagesView.messageId=this.messageId,(this.messageId&&!this.model.messages.get(this.messageId)||!this.messageId&&!this.model.messages.nextComplete)&&this.model.messages.reset(),_.delay(this.model.messages.fetch.bind(this.model.messages)),this.$editor=$(),this.autoScroll=!!_.isUndefined(e.autoScroll)||e.autoScroll,this.onHide=this.onHide.bind(this),this.onShow=this.onShow.bind(this),$(window).on("blur",this.onHide),$(window).on("focus",this.onShow),this.onScroll=_.throttle(this.onScroll,300);e=v.add(this);this.listenTo(e,"drop",function(e){e.forEach(function(e){x(e)&&this.model.postMessage({content:""},e)},this)})},onShow:function(){this.hidden=!1,this.markMessageAsRead()},onHide:function(){this.hidden=!0},onDispose:function(){$(window).off("blur",this.onHide),$(window).off("focus",this.onShow)},updateConnectionProblemBanner:function(){this.$connectionProblemBanner.toggleClass("disconnected",!h.session.socket.connected)},render:function(){return this.toolbar=new g({point:"io.ox/chat/detail/toolbar",title:u("Chat actions")}),this.toolbar.render(new e.Baton({model:this.model,view:this.toolbar})),this.chatMemberview=new s({collection:this.model.members}),this.$el.append($('<div class="header">').append(new o({model:this.model}).render().$el,(this.model.isPrivate()?this.renderTitle():$("<div>").append(this.renderTitle().addClass("small-line"),this.chatMemberview.render().$el)).addClass("flex-grow flex-center-vertically"),this.$dropdown=$('<div class="dropdown">').append($('<button type="button" class="btn btn-link dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">').attr("title",u("More actions")).append(c.svg({icon:"fa-bars"}).attr("title",u("More actions"))),this.renderDropdown()).css("visibility","hidden")),this.toolbar.$el,this.$scrollpane.on("scroll",$.proxy(this.onScroll,this)).append(this.$paginatePrev=$('<div class="paginate prev">').hide(),$('<div class="conversation">').append(this.messagesView.render().$el,new d.View({roomId:this.model.id}).render().$el),this.$paginateNext=$('<div class="paginate next">').hide()),this.$connectionProblemBanner,$('<div class="controls">').append(this.renderJumpDown(),this.renderEditor())),this.onUpdatePaginators(),this.markMessageAsRead(),this.updateConnectionProblemBanner(),0<this.$dropdown.find(".dropdown-menu").children().length&&this.$dropdown.css("visibility","visible"),this},renderJumpDown:function(){var e=u("Scroll to newest message");return this.$jumpDown=$('<button class="btn btn-default btn-circle jump-down">').attr("title",e).append(c.svg({icon:"fa-chevron-down"}).attr("aria-label",e),this.$unreadCounter=$('<span class="badge">').text(this.model.get("unreadCount")||"")),this.$jumpDown.toggle(this.isJumpDownVisible())},renderEditor:function(){if(this.isMember){var e=$('<div class="editor-container">').append($('<div class="reference-container">'),this.$editor=$('<textarea rows="1">').attr({"aria-label":u("Message"),placeholder:u("Message"),maxlength:h.serverConfig.maxMsgLength}).val(this.model.get("draft")||"")),t=$('<button type="button" class="btn btn-link pull-right send-btn">').attr("aria-label",u("Send")).append(c.svg({icon:"fa-paper-plane"}).attr("title",u("Send"))),i=$('<button type="button" class="btn btn-link pull-right toggle-emoji">').attr("aria-label",u("Add emoji")).append(c.svg({icon:"fa-smile-o"}).attr("title",u("Add emoji"))),o=$('<button type="button" class="btn btn-link cancel-btn">').attr("aria-label",u("Cancel")).append(c.svg({icon:"fa-times"}).attr("title",u("Cancel")));return[$('<button type="button" class="btn btn-link pull-right file-upload-btn">').attr("aria-label",u("Upload file")).append(c.svg({icon:"fa-paperclip"}).attr("title",u("Upload file"))),$('<input type="file" class="file-upload-input hidden" multiple>'),e,o,i,t]}if(this.model.isChannel())return $('<button type="button" class="btn btn-default btn-action join">').attr({"data-cmd":"join-channel","data-id":this.model.get("roomId")}).append(u("Join"))},updateEditor:function(){this.$(".controls").empty().append(this.renderEditor())},renderDropdown:function(){var i=$('<ul class="dropdown-menu dropdown-menu-right">'),o=this.model.id;return this.toolbar.$(".more-dropdown .dropdown-menu").children().toArray().forEach(function(e){var t=$(e);t.hasClass("divider")?i.append('<li class="divider" role="separator">'):(e=t.find("a")).length&&(t=e.text(),e=e.attr("data-cmd"),i.append($('<li role="presentation">').append($('<a href="#" role="button">').attr({"data-cmd":e,"data-id":o}).text(t))))}),i},updateDropdown:function(){this.toolbar.render(new e.Baton({model:this.model,view:this.toolbar})),this.$dropdown.find(".dropdown-menu").replaceWith(this.renderDropdown())},renderTitle:function(){return $('<h2 class="title">').text(this.model.getTitle()||" ")},isScrolledToBottom:function(){var e=this.$scrollpane;return e.scrollTop()+e.height()>e.prop("scrollHeight")-30},onBeforeAdd:function(){var e=this.messagesView.$el.children().first(),t=(e.position()||{}).top||0,i=this.isScrolledToBottom();this.scrollInfo={firstChild:e,prevTop:t,isScrolledDown:i}},onAfterAdd:function(e){var t=this.$scrollpane,i=this.scrollInfo.firstChild,o=this.scrollInfo.prevTop,s=this.scrollInfo.isScrolledDown,n=1<e.length,e=a.isMyself(e[0].get("sender"));(n||e||s)&&(this.autoScroll?this.scrollToBottom():i.position().top-o&&t.scrollTop(i.position().top-o)),this.toggleAutoScroll(!0),delete this.scrollInfo,this.markMessageAsRead()},onMessageDelete:function(e){a.deleteMessage(e).fail(function(){p("error",u("The message could not be deleted."))})},onCancelSpecialMode:function(){"edit"===this.specialMode&&this.$editor.val(""),this.$messageReference&&this.$messageReference.remove(),this.$(".controls").removeClass("edit-mode reply-mode system text preview emoji"),this.specialMode=!1,this.messageReference=null,_.defer(function(){this.$editor.focus().trigger("input")}.bind(this))},onMessageEdit:function(e){this.onCancelSpecialMode();var t=this.getMessageNode(e);t&&this.$scrollpane.scrollTop(t[0].offsetTop-this.$scrollpane.height()+t.height()+4),this.specialMode="edit",this.messageReference=e,this.$(".controls").addClass("edit-mode"),this.$editor.val(e.get("content")).focus().trigger("input")},onMessageReply:function(e){this.onCancelSpecialMode();var t=this.getMessageNode(e);t.length&&t[0].scrollIntoView(!1);t=h.users.getByMail(e.get("sender"));this.specialMode="reply",this.messageReference=e,this.$messageReference=$('<div class="message-quote">').append($('<div class="sender">').text(t.getName()),new l({model:e,inEditor:!0}).render().$el),this.$messageReference.find("button").remove(),this.$(".controls").addClass("reply-mode"),this.$(".reference-container").empty().append(this.$messageReference)},scrollToBottom:function(){var e,t=16777215,i=this.$scrollpane;!this.messageId||(e=this.model.messages.get(this.messageId))&&(e=this.messagesView.$('[data-cid="'+e.cid+'"]').position().top-i.height()/2,t=i.scrollTop()+e,delete this.messageId),i.scrollTop(t),setTimeout(function(e){i.scrollTop(e)},10,t)},toggleAutoScroll:function(e){void 0===e&&(e=!this.autoScroll),this.autoScroll=e},onEditorKeydown:function(e){var t;27===e.which&&this.specialMode&&(e.preventDefault(),e.stopPropagation(),this.onCancelSpecialMode()),38!==e.which||this.specialMode||this.model.get("draft")||(t=this.model.getLastMessageForUser(a.userId))&&this.onMessageEdit(t),13===e.which&&(e.shiftKey||e.ctrlKey||e.metaKey||e.altKey||(e.preventDefault(),this.onSend(),this.$editor.focus().trigger("input")))},onEditorInput:function(){var e=this.$editor[0],t=e.value;this.model.set("draft",t,{silent:!0}),e.rows=1;var i=e.clientHeight,o=e.scrollHeight;e.rows=Math.min(10,Math.round(o/i)),t&&d.propagate(this.model.id)},onTriggerFileupload:function(){this.$(".file-upload-input").trigger("click")},onFileuploadNew:function(){var e=this.$(".file-upload-input"),t=e[0].files;if(!(t.length<=0)){for(var i=0;i<=t.length-1;i++)this.model.postMessage({content:""},t.item(i));e.val("")}},onFileupload:function(){var e=this.$(".file-upload-input"),t=e[0].files;if(0<t.length)for(var i=0;i<=t.length-1;i++){var o=t.item(i);x(o)&&this.model.postMessage({content:""},o)}e.val("")},onJumpDown:function(){this.model.messages.nextComplete?this.scrollToBottom():(this.model.messages.reset(),this.model.messages.fetch())},onSend:function(){var e=this.$editor.val();0<e.trim().length&&this.onPostMessage(e),this.$editor.val(""),this.model.unset("draft",{silent:!0})},onPostMessage:function(e){var t=h.serverConfig.maxMsgLength||-1;0<t&&e.length>t?b.yell("error",u("The message cannot be sent because it exceeds the maximum message length of %1$s characters.",t)):(this.model.messages.nextComplete||(this.model.messages.reset(),this.model.messages.fetch()),a.typing(this.model.id,!1),"edit"===this.specialMode?(a.editMessage(e,this.messageReference).fail(this.model.handleError),this.onCancelSpecialMode()):"reply"===this.specialMode?(t=this.messageReference.omit("edited","replyTo"),this.model.postMessage({content:e,replyTo:t}),this.onCancelSpecialMode()):this.model.postMessage({content:e}))},onChangeTitle:function(e){this.$(".title").text(e.getTitle()||" ")},onChangeUnreadCount:function(){this.$unreadCounter.text(this.model.get("unreadCount")||"")},onChangeMembers:function(){var e=this.model.isMember(),t=this.isMember!==e;this.isMember=e,t&&(this.updateEditor(),this.updateDropdown())},onScroll:function(){var e,t,i;this.disposed||(this.$jumpDown.toggle(this.isJumpDownVisible()),this.$(".messages").is(":empty")||((t=this).model.messages.prevComplete||((e=t.$paginatePrev).hasClass("io-ox-busy")||e.position().top<2*-e.height()||(e.busy(),t.model.messages.paginate("older").then(function(){e.idle()}))),(t=this).model.messages.nextComplete||((i=t.$paginateNext).hasClass("io-ox-busy")||i.position().top-i.height()>i.parent().height()||(i.busy(),t.model.messages.paginate("newer").then(function(){i.idle()}))),this.markMessageAsRead()))},onChangeRoomId:function(){this.$("[data-cid="+this.model.cid+"]").attr("data-cid",this.model.get("roomId"))},markMessageAsRead:function(){var e;this.hidden||this.model.isChannel()&&!this.model.isMember()||((e=this.model.messages.findLastIndex(function(e){return!a.isMyself(e.get("sender"))}))<0||"seen"!==(e=this.model.messages.at(e)).get("deliveryState")&&e.updateDelivery("seen"))},isJumpDownVisible:function(){return this.$scrollpane.scrollTop()+this.$scrollpane.height()<this.$scrollpane.prop("scrollHeight")-50},onUpdatePaginators:function(){var e=this.isScrolledToBottom();this.$(".paginate.prev").idle().toggle(!this.model.messages.prevComplete&&0<this.model.messages.length),this.$(".paginate.next").idle().toggle(!this.model.messages.nextComplete&&0<this.model.messages.length),e&&!this.isScrolledToBottom()&&this.scrollToBottom()},onComplete:function(e){this.$(".paginate."+e).idle().hide()},getMessageNode:function(e,t){return this.$('.message[data-cid="'+e.cid+'"] '+(t||""))},onToggleEmoji:function(){if(this.emojiView)return this.emojiView.toggle();!1!==this.emojiView&&(this.emojiView=!1,require(["io.ox/core/emoji/view"],function(e){this.emojiView=new e({closeOnInsert:!0,closeOnFocusLoss:!0}),this.listenTo(this.emojiView,"insert",this.insertEmoji),this.$el.append(this.emojiView.$el),this.emojiView.render()}.bind(this)))},insertEmoji:function(e){var t=this.$editor[0],i=t.value,o=t.selectionStart,s=document.activeElement;void 0!==o?(t.value=i.substr(0,o)+e+i.substr(o),t.focus(),o+=e.length,t.setSelectionRange(o,o),s&&s.focus()):t.value+=e,this.$editor.trigger("input")}});function w(e,t,i,o,s){e.attr({"data-prio":"lo","data-section":s}).append($('<a href="#" role="menuitem" draggable="false" tabindex="-1">').attr({"data-cmd":t,"data-id":i}).text(o).on("click",r.forward))}function x(e){var t=h.serverConfig.maxFileSize||-1;if(e.size<t)return 1;b.yell("error",u('The file "%1$s" cannot be uploaded because it exceeds the maximum file size of %2$s',e.name,f.fileSize(t)))}return e.point("io.ox/chat/detail/toolbar").extend({id:"back",index:100,custom:!0,draw:m.back},{id:"title",index:200,custom:!0,draw:function(e){e.view.listenTo(e.model,"change:title",function(){this.text(e.model.getTitle())}.bind(this)),this.addClass("toolbar-title").attr("data-prio","hi").text(e.model.getTitle())}},{id:"switch-to-floating",index:300,custom:!0,draw:m.detach},{id:"toggle-favorite",index:400,custom:!0,draw:function(e){var t=e.model;t.get("active")&&(e=t.isFavorite()?u("Remove from favorites"):u("Add to favorites"),w(this,"toggle-favorite",t.id,e,"general"))}},{id:"edit-group",index:500,custom:!0,draw:function(e){e=e.model;e.isMember()&&!e.isPrivate()&&w(this,"edit-group-chat",e.id,e.isChannel()?u("Edit channel"):u("Edit chat"),"general")}},{id:"close-chat",index:600,custom:!0,draw:function(e){e=e.model;e.get("active")&&w(this,"unsubscribe-chat",e.id,e.isChannel()?u("Close channel"):u("Close chat"),"general")}},{id:"leave-group",index:700,custom:!0,draw:function(e){e=e.model;(e.isGroup()||e.isChannel())&&e.isMember()&&w(this,e.isChannel()?"leave-channel":"leave-group",e.id,e.isChannel()?u("Leave channel"):u("Leave chat"),"actions")}},{id:"join-channel",index:800,custom:!0,draw:function(e){e=e.model;e.isChannel()&&(e.isMember()||e.get("active")||w(this,"join-channel",e.id,u("Join channel"),"join-leave"))}},{id:"delete-room",index:800,custom:!0,draw:function(e){e=e.model;e.isPrivate()||e.isMember()&&(e.isGroup()&&!e.isAdmin()||e.isChannel()&&!e.isAdmin()&&!e.isCreator()||w(this,"delete-chat",e.id,e.isChannel()?u("Delete channel"):u("Delete chat"),"join-leave"))}}),t});