define("io.ox/files/api",["io.ox/core/http","io.ox/core/folder/api","io.ox/core/api/user","io.ox/core/api/backbone","io.ox/core/api/collection-pool","io.ox/core/api/collection-loader","io.ox/core/capabilities","io.ox/core/extensions","io.ox/core/api/jobs","io.ox/core/util","io.ox/files/permission-util","io.ox/find/api","settings!io.ox/core","settings!io.ox/files","gettext!io.ox/files"],function(l,s,e,o,t,i,n,d,c,p,r,u,a,f,m){"use strict";var g={},h=/^application\/(force-download|binary|x-download|octet-stream|vnd|vnd.ms-word.document.12|odt|x-pdf)$/i;g.Model=o.Model.extend({constructor:function(e,t){var i;(e=e||{}).space?i={filename:e.name,file_size:e.size,file_mimetype:e.mimeType,spaceId:e.space,id:e.id,origData:e,source:"compose"}:_.isObject(e.mail)?i={filename:e.filename,file_size:e.size,file_mimetype:e.content_type,id:e.id,folder_id:e.mail.folder_id||null,origData:e,source:"mail"}:_.isNumber(e.attached)&&_.isNumber(e.module)?i={filename:e.filename,file_size:e.file_size||e.size,file_mimetype:e.file_mimetype||e.fmtType,id:e.id||e.managedId,folder_id:e.folder,module:e.module,origData:e,source:"pim"}:_.isString(e.guardUrl)||"guardDrive"===e.source||"guardMail"===e.source?(i=e).content_type&&!i.file_mimetype&&(i.file_mimetype=e.content_type):(i=e).source="drive",o.Model.call(this,i,t),this.listenTo(this,"change:com.openexchange.file.sanitizedFilename",function(e,t){var i=this.get("versions");if(i){for(var o=0;o<i.length;o++)if(i[o].version===e.get("version")){i[o]["com.openexchange.file.sanitizedFilename"]=t;break}this.set("versions",i)}})},isFolder:function(){return this.has("standard_folder")},isFile:function(){return!this.isFolder()&&this.isDriveItem()},isDriveItem:function(){return"drive"===this.get("source")||"guardDrive"===this.get("source")},isSVG:function(e){return/^image\/svg/.test(e||this.getMimeType())},isTiff:function(e){return/^image\/tif?f/.test(e||this.getMimeType())},isImage:function(e){return/^image\//.test(e||this.getMimeType())&&!this.isSVG(e)},isAudio:function(e){return/^audio\//.test(e||this.getMimeType())},isVideo:function(e){return/^video\//.test(e||this.getMimeType())},isOffice:function(e){return/^application\/(msword|excel|powerpoint|vnd\.(ms-word|ms-excel|ms-powerpoint|oasis|openxmlformats))/.test(e||this.getMimeType())},isPDF:function(e){return/^application\/pdf$/.test(e||this.getMimeType())},isZIP:function(e){return/^application\/zip$/.test(e||this.getMimeType())},isText:function(e){return/^(text\/plain|application\/rtf|text\/rtf)$/.test(e||this.getMimeType())},isWordprocessing:function(e){return/^application\/(?:msword|vnd\.(?:ms-word|openxmlformats-officedocument\.wordprocessingml|oasis\.opendocument\.text))/.test(e||this.getMimeType())},isSpreadsheet:function(e){return/^application\/(?:excel|vnd\.(?:ms-excel|openxmlformats-officedocument\.spreadsheetml|oasis\.opendocument\.spreadsheet))/.test(e||this.getMimeType())},isPresentation:function(e){return/^application\/(?:powerpoint|vnd\.(?:ms-powerpoint|openxmlformats-officedocument\.presentationml|oasis\.opendocument\.presentation))/.test(e||this.getMimeType())},isPgp:function(e){return/^application\/pgp(?:-encrypted)*$/.test(e)||this.isGuard()},isGuard:function(){return/^guard/.test(this.get("source"))},isEncrypted:function(){return this.isPgp()||g.isGuardExtension({filename:this.get("filename")})},isLocked:function(){return this.get("locked_until")>_.now()},isMailAttachment:function(){return"mail"===this.get("source")||"guardMail"===this.get("source")},isComposeAttachment:function(){return"compose"===this.get("source")},isPIMAttachment:function(){return"pim"===this.get("source")},isEmptyFile:function(){return this.isFile()&&!this.get("filename")},getDisplayName:function(){return this.get("com.openexchange.file.sanitizedFilename")||this.get("filename")||this.get("title")||""},getExtension:function(){var e=String(this.get("filename")||"").split(".");return 1===e.length?"":e.pop().toLowerCase()},getGuardExtension:function(){var e=String(this.get("filename")||"").split("."),e=2<e.length&&"pgp"===e.pop().toLowerCase()?e[e.length-1].toLowerCase():"";return e},getMimeType:function(){var e=String(this.get("file_mimetype")).toLowerCase().split(";")[0];return"guardDrive"===this.get("source")&&this.get("meta")&&this.get("meta").OrigMime&&(e=this.get("meta").OrigMime),h.test(e)?g.mimeTypes[this.getExtension()]||e:"audio/mp3"===e?"audio/mpeg":e},getGuardMimeType:function(){var e=this.get("meta"),e=e&&e.OrigMime;return e=!e||h.test(e)?g.mimeTypes[this.getGuardExtension()]||this.getMimeType():e},getFileType:function(){if(this.isFolder&&this.isFolder())return"folder";if(this.getExtension){var e,t=this.getExtension();for(e in this.types)if(this.types[e].test(t))return e}return!1},getGuardType:function(){var e=this.getGuardExtension();if(e)for(var t in this.types)if(this.types[t].test(e))return t;return this.getFileType()},types:{image:/^(gif|bmp|tif?f|jpe?g|gmp|png|psd|heic?f?)$/,audio:/^(aac|mp3|m4a|m4b|ogg|opus|wav)$/,video:/^(avi|m4v|mp4|ogv|ogm|mov|mpeg|webm|wmv)$/,vcf:/^(vcf)$/,doc:/^(docx|docm|dotx|dotm|odt|ott|doc|dot|rtf)$/,xls:/^(csv|xlsx|xlsm|xltx|xltm|xlam|xls|xlt|xla|xlsb|ods|ots)$/,ppt:/^(pptx|pptm|potx|potm|ppsx|ppsm|ppam|odp|otp|ppt|pot|pps|ppa|odg|otg)$/,pdf:/^pdf$/,zip:/^(zip|tar|gz|rar|7z|bz2)$/,txt:/^(txt|md)$/,odfmisc:/^(otf|odf|odi|oti|odc|otc)$/,guard:/^(grd|grd2|pgp)$/i},supportsPreview:function(){if(this.isEncrypted())return!1;var e=this.getMimeType();return this.isImage(e)?"thumbnail":this.isAudio(e)?"cover":!(!n.has("document_preview")||!(this.isPDF(e)||this.isOffice(e)||this.isText(e)))&&"preview"},getUrl:function(e,t){return g.getUrl(this.toJSON(),e,t)},hasWritePermissions:function(){return r.hasObjectWritePermissions(this.toJSON())},getClosestFolderModelSync:function(){var e=this.isFile()?this.get("folder_id"):this.get("id"),e=s.pool.models[e];return e||{}},getItemAccountSync:function(){return this.getClosestFolderModelSync().get("account_id")},isSharedFederatedSync:function(){var e=this.getClosestFolderModelSync();return!_.isEmpty(e)&&e.is("federated-sharing")},getAccountDisplayNameSync:function(){var e=this.getClosestFolderModelSync();return e&&e.getAccountDisplayName()},getAccountError:function(){return this.get("com.openexchange.folderstorage.accountError")},getParentFolder:function(){return(this.isFile()?this:s.pool.getModel(this.get("id"))).get("folder_id")}}),g.Collection=o.Collection.extend({model:g.Model}),g.mimeTypes={jpg:"image/jpeg",jpeg:"image/jpeg",png:"image/png",gif:"image/gif",tif:"image/tiff",tiff:"image/tiff",bmp:"image/bmp",heic:"image/heic",heif:"image/heif",mp3:"audio/mpeg",ogg:"audio/ogg",opus:"audio/ogg",aac:"audio/aac",m4a:"audio/mp4",m4b:"audio/mp4",wav:"audio/wav",mp4:"video/mp4",m4v:"video/mp4",ogv:"video/ogg",ogm:"video/ogg",webm:"video/webm",wmv:"video/video/x-ms-wmv",csv:"text/csv",odc:"application/vnd.oasis.opendocument.chart",otc:"application/vnd.oasis.opendocument.chart-template",odb:"application/vnd.oasis.opendocument.database",odf:"application/vnd.oasis.opendocument.formula",otf:"application/vnd.oasis.opendocument.formula-template",odg:"application/vnd.oasis.opendocument.graphics",otg:"application/vnd.oasis.opendocument.graphics-template",odi:"application/vnd.oasis.opendocument.image",oti:"application/vnd.oasis.opendocument.image-template",odp:"application/vnd.oasis.opendocument.presentation",otp:"application/vnd.oasis.opendocument.presentation-template",ods:"application/vnd.oasis.opendocument.spreadsheet",ots:"application/vnd.oasis.opendocument.spreadsheet-template",odt:"application/vnd.oasis.opendocument.text",odm:"application/vnd.oasis.opendocument.text-master",ott:"application/vnd.oasis.opendocument.text-template",oth:"application/vnd.oasis.opendocument.text-web",pdf:"application/pdf",xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",xlsm:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",xltx:"application/vnd.openxmlformats-officedocument.spreadsheetml.template",xltm:"application/vnd.openxmlformats-officedocument.spreadsheetml.template",pptx:"application/vnd.openxmlformats-officedocument.presentationml.presentation",pptm:"application/vnd.openxmlformats-officedocument.presentationml.presentation",ppsx:"application/vnd.openxmlformats-officedocument.presentationml.slideshow",potx:"application/vnd.openxmlformats-officedocument.presentationml.template",potm:"application/vnd.openxmlformats-officedocument.presentationml.template",docx:"application/vnd.openxmlformats-officedocument.wordprocessingml.document",docm:"application/vnd.openxmlformats-officedocument.wordprocessingml.document",dotx:"application/vnd.openxmlformats-officedocument.wordprocessingml.template",dotm:"application/vnd.openxmlformats-officedocument.wordprocessingml.template",doc:"application/msword",dot:"application/msword",xls:"application/vnd.ms-excel",xlb:"application/vnd.ms-excel",xlt:"application/vnd.ms-excel",ppt:"application/vnd.ms-powerpoint",pot:"application/vnd.ms-powerpoint",pps:"application/vnd.ms-powerpoint"},g.getExtension=function(e,t){e=e&&(e["com.openexchange.file.sanitizedFilename"]||e.filename||e.title),e=String(e||"").split("."),e=!t&&2<e.length&&"pgp"===e.pop().toLowerCase()?e[e.length-1].toLowerCase():1<e.length?e.pop().toLowerCase():"";return e},g.isText=function(e){return g.Model.prototype.types.txt.test(g.getExtension(e))},g.isPDF=function(e){return g.Model.prototype.types.pdf.test(g.getExtension(e))},g.isWordprocessing=function(e){return g.Model.prototype.types.doc.test(g.getExtension(e))},g.isPresentation=function(e){return g.Model.prototype.types.ppt.test(g.getExtension(e))},g.isSpreadsheet=function(e){return g.Model.prototype.types.xls.test(g.getExtension(e))},g.isOffice=function(e){return g.isWordprocessing(e)||g.isPresentation(e)||g.isSpreadsheet(e)},g.isImage=function(e){return g.Model.prototype.types.image.test(g.getExtension(e))},g.isAudio=function(e){return g.Model.prototype.types.audio.test(g.getExtension(e))},g.isVideo=function(e){return g.Model.prototype.types.video.test(g.getExtension(e))},g.isGuardExtension=function(e){e=g.getExtension(e,!0);return g.Model.prototype.types.guard.test(e)},g.getUrl=function(e,t,i){if(i=_.extend({scaleType:"contain"},i),e.space)return ox.apiRoot+"/mail/compose/"+e.space+"/attachments/"+e.id+"?session="+ox.session;var o="/files",n=encodeURIComponent(e.folder_id),r=encodeURIComponent(e.id),a="&user="+ox.user_id+"&context="+ox.context_id+"&sequence="+(e.last_modified||1),s="?action=document&folder="+n+"&id="+r+(void 0!==e.version&&!1!==i.version&&null!==i.version?"&version="+e.version:"")+a,l=e.filename?"/"+encodeURIComponent(e.filename):"",d=i.width&&i.height?"&scaleType="+i.scaleType+"&width="+i.width+"&height="+i.height:"",c=_([ox.user_id,ox.context_id,e.last_modified]).compact().join(".")||"";switch(c&&(s+="&"+c),i.params&&(s+="&"+_.serialize(i.params)),t){case"download":o=e.meta&&e.meta.downloadUrl||o+l+s+"&delivery=download";break;case"thumbnail":if(i.noSharding){o=e.meta&&e.meta.thumbnailUrl||o+s+"&delivery=view"+d;break}return p.getShardingRoot(e.meta&&e.meta.thumbnailUrl||o+s+"&delivery=view"+d);case"preview":if(i.noSharding){o=e.meta&&e.meta.previewUrl||o+s+"&delivery=view"+d+"&format=preview_image&content_type=image/jpeg";break}return p.getShardingRoot(e.meta&&e.meta.previewUrl||o+s+"&delivery=view"+d+"&format=preview_image&content_type=image/jpeg");case"cover":o="/image/file/mp3Cover?folder="+n+"&id="+r+d+a+"&content_type=image/jpeg&"+c;break;case"play":o=o+s+"&delivery=view";break;default:o=o+l+s+"&delivery=view"}return ox.apiRoot+o};var v=t.create("files",{Collection:g.Collection,Model:g.Model});v.add=_.wrap(v.add,function(e,t,i){_.isUndefined(i)&&(i=t,t="detail");var o=this.get(t),n=[];i=[].concat(i),"detail"===t&&i.forEach(function(e){!o.get(_.cid(e))||o.get(_.cid(e))&&o.get(_.cid(e)).get("last_modified")>=e.last_modified?e.expired=!1:(e.expired=!0,n.push(_.cid(e)))});i=e.call(this,t,i);return 0<n.length&&o.trigger("expired_models",n),i});var x="1,2,3,5,20,23,51,52,108,700,702,703,704,705,707,711,7040",y=l.getAllColumns("files",!0),t=a.get("folder/mailattachments",{});_.isEmpty(t)?y=y.replace(",7030",""):x+=",7030";function w(e){if(e.data=e.data||{},e&&e.code&&("UPL-0005"===e.code||"IFO-1700"===e.code))e.data.custom={type:"error",text:m(e.error,e.error_params[0],e.error_params[1])};else if(e&&e.code&&"IFO-0100"===e.code&&e.problematic&&e.problematic[0]&&700===e.problematic[0].id)e.data.custom={type:"error",text:m("The provided filename exceeds the allowed length.")};else if(e&&e.code&&"FLS-0024"===e.code)e.data.custom={type:"error",text:m("The allowed quota is reached.")};else{if(e.error&&"abort"===e.error)return;e.data.custom={type:"error",text:m("This file could not be uploaded.")+(/^0 /.test(e.error)?"":"\n"+e.error)}}return e}function b(e){if(/^folder\./.test(e)){var t=s.pool.getModel(e.substr(7)).toJSON();return t.folder_id="folder",new g.Model(t)}return v.get("detail").get(e)}function T(e){return v.add("detail",e),v.get("detail").get(_.cid(e)).toJSON()}function M(e){return this.get(_.cid(e))}function F(e){return this.get(_.cid(e)).toJSON()}_.extend(g,Backbone.Events),g.pool=v,g.collectionLoader=new i({module:"files",getQueryParams:function(e){return!/^virtual\//.test(e.folder)&&{action:"all",folder:e.folder||a.get("folder/infostore"),columns:x,sort:e.sort||"702",order:e.order||"asc",pregenerate_previews:!1!==e.pregenerate_previews,timezone:"utc"}},fetch:function(t){var e=this.module,i=e+"/"+_.cacheKey(_.extend({session:ox.session},t)),o=ox.rampup[i],n=this.noSelect(t),r=this.virtual(t),a=this;return o?(delete ox.rampup[i],$.when(o)):(n&&1===s.pool.getModel(t.folder).attributes.own_rights&&(t.tree=1,t.parent=t.folder,e="folders",t.action="list",t.columns="1,2,3,5,20,23,51,52"),r?$.when(r):l.wait().then(function(){return a.mimeTypeFilter?a.filterByMimeType(t).then(function(e){return a.filter&&(e=_(e).filter(a.filter)),a.useSlice?Array.prototype.slice.apply(e,t.limit.split(",")):e}):$.when(a.httpGet(e,t),ox.manifests.loadPluginsFor("io.ox/files/filter"))}).then(function(e){return e=(e=_.isFunction(a.filter)?_(e).filter(a.filter):e).filter(function(t){return d.point("io.ox/files/filter").filter(function(e){return!1!==e.invoke("isEnabled",this,t)}).map(function(e){return e.invoke("isVisible",this,t)}).reduce(function(e,t){return e&&t},!0)}),a.useSlice?Array.prototype.slice.apply(e,t.limit.split(",")):e}))},httpGet:function(i,r){if("9"!==r.folder)return s.list(r.folder).then(function(t){"5"===String(r.sort)&&(t=_(t).sortBy("last_modified")),"desc"===r.order&&t.reverse();var e=r.limit.split(/,/),o=Number(e[0]),n=Number(e[1]),e=o-t.length+","+(n-t.length);return t.length>=n?t.slice(o,n):l.GET({module:i,params:_.extend({},r,{limit:e})}).then(function(e){var i=[].concat(t,new Array(Math.max(0,o-t.length)),e).slice(o,n);return i.forEach(function(e,t){i[t]=T(e)}),i},function(e){return"IFO-0400"===e.code&&0===e.error_params.length&&e.error_params.push(r.folder),g.trigger("error error:"+e.code,e),ox.debug&&console.warn("files.httpGet",e.error,e),[]})});var o=[];return s.get("virtual/favorites/infostore").then(function(t){return s.list("virtual/favorites/infostore").then(function(e){return e.length&&o.push(t),s.multipleLists(["virtual/drive/private","virtual/drive/public","virtual/filestorage"]).then(function(e){switch(n.has("share_links || invite_guests")||(e=_.filter(e,function(e){return"virtual/myshares"!==e.id})),o=o.concat(e),String(r.sort)){case"702":o=_(o).sortBy("title");break;case"5":o=_.sortBy(o,function(e){return e.last_modified||0})}return"desc"===r.order&&o.reverse(),o})})})},filterByMimeType:function(r){var a=this;return s.get(r.folder).then(function(i){return s.list(r.folder).then(function(t){"5"===String(r.sort)&&(t=_(t).sortBy("last_modified")),"desc"===r.order&&t.reverse();var e=r.limit.split(/,/),o=Number(e[0]),n=Number(e[1]);if(t.length>=n)return t.slice(o,n);e={data:{facets:[{facet:"folder",filter:null,value:r.folder},{facet:"account",filter:null,value:i.account_id},{facet:"file_type",filter:{fields:["file_extension"],queries:a.mimeTypeFilter},value:a.mimeTypeFilter}],options:{includeSubfolders:!1,sort:r.sort,order:r.order},size:n,start:o},params:{module:"files"}};return u.query(e).then(function(e){e=e.results;var i=[].concat(t,new Array(Math.max(0,o-t.length)),e).slice(o,n);return i.forEach(function(e,t){i[t]=T(e)}),a.addIndex(o,r,i),a.done(),i},function(e){return"IFO-0400"===e.code&&0===e.error_params.length&&e.error_params.push(r.folder),g.trigger("error error:"+e.code,e),ox.debug&&console.warn("files.filter",e.error,e),[]})})})},PRIMARY_PAGE_SIZE:210,SECONDARY_PAGE_SIZE:210}),g.collectionLoader.noSelect=function(e){return!s.pool.getModel(e.folder).can("read")},g.collectionLoader.each=function(e){g.pool.add("detail",e)},g.collectionLoader.setMimeTypeFilter=function(e){return!_.isEqual(g.collectionLoader.mimeTypeFilter,e)&&(g.collectionLoader.mimeTypeFilter=e,!0)},g.resolve=function(e,t){e=_(e).chain().map(b).compact().value();return!1===t?e:_(e).invoke("toJSON")},g.get=function(t,e){if((e=_.extend({cache:!0},e)).cache){var i=v.get("detail").get(_.cid(t));if(i&&!i.get("expired")&&i.has("description"))return $.when(i.toJSON())}i=_.extend({action:"get",id:t.id,folder:t.folder_id||t.folder,timezone:"UTC"},e.params);return e.columns&&(i.columns=e.columns),l.GET({module:"files",params:i}).then(function(e){return t.origin&&(e.origin=_.clone(t.origin)),T(e)},function(e){throw g.trigger("error error:"+e.code,e),e})},g.getAll=function(e,t){return t=_.extend({columns:x},t),l.GET({module:"files",params:_.extend({action:"all",columns:t.columns,folder:e,timezone:"UTC"},t.params)}).then(function(e){return v.add("detail",e),e},function(e){throw g.trigger("error error:"+e.code,e),e})},g.getList=function(t,i){var e=t,o=v.get("detail");if(i=_.extend({cache:!0,errors:!1},i),0===t.length)return $.when([]);if(i.cache&&(e=_(t).reject(M,o)),i.fullModels&&0===e.length)return $.when(_(t).map(M,o));if(0===e.length)return $.when(_(t).map(F,o));if(!i.errors)return l.fixList(e,l.PUT({module:"files",params:{action:"list",columns:x,timezone:"UTC"},data:l.simplify(e)})).then(function(e){return _(e.filter(Boolean)).each(T),i.fullModels?_(t).map(M,o):_(t).map(F,o)});try{return l.pause(),$.when.apply($,_.map(t,function(t){return g.get(t,{cache:i.cache}).pipe(null,function(e){return(e=_.extend({},e)).file=t,$.when(e)})})).pipe(function(){var e=_(arguments).toArray();return _.map(e,function(e){return e&&!e.error?(i.fullModels?M:F).call(o,e):e})})}finally{l.resume()}};function E(e,t){return l.pause(),_(e).each(function(e){l.PUT({module:"files",params:{action:t,id:e.id,folder:e.folder_id||e.folder,timezone:"UTC"},appendColumns:!1})}),l.resume()}function S(e,t){var i=v.get("detail");e.forEach(function(e){e=i.get(_.cid(e));e&&e.set("locked_until",t)})}g.unlock=function(e){return S(e=_.isArray(e)?e:[e],0),E(e,"unlock").done(function(){g.propagate("unlock",e)})},g.lock=function(e){return S(e=_.isArray(e)?e:[e],_.now()+6e4),E(e,"lock").then(function(){return g.propagate("lock",e)})},g.clear=function(e){return v.getByFolder(e).forEach(function(e){e.expired=!0,e.reset()}),l.PUT({module:"folders",appendColumns:!1,params:{action:"clear",tree:"1"},data:[e]}).done(function(){g.propagate("clear",{folder_id:e})})},g.restore=function(e){_.isArray(e)||(e=[e]);var t=[];return _(e).each(function(e){t.push({id:e.get("id"),folder:e.get("folder_id")}),_(g.pool.collections).invoke("remove",e),e.set("unread",0)}),l.PUT({module:"infostore",params:{action:"restore",folder:"1"===t[0].id||/^default\d+/.test(t[0].id)?0:1},data:t,appendColumns:!1}).done(function(e){var t,i=[];_.each(e,function(e){t=e.path[0].id,_.contains(i,t)||i.push(t),g.trigger("refresh:listviews")})}).fail(function(){_(e).each(function(e){g.propagate("restore:fail",e.toJSON())})})};var C,k=_.debounce(function(){g.trigger("refresh:listviews")},0);function A(e){g.trigger("beforedelete",e);var t=v.get("detail"),e=_(e).map(function(e){return t.get(_.cid(e))});t.remove(e)}function P(e,t,i){l.pause();var o=_(e).where({folder_id:"folder"}),e=_(e).difference(o);return e&&0<e.length&&l.PUT({module:"files",params:{action:"move",folder:t,ignoreWarnings:i,allow_enqueue:!0},data:e,appendColumns:!1}),_(o).each(function(e){s.move(e.id,t,{ignoreWarnings:i,enqueue:!0})}),l.resume()}function z(e,i,o){return l.pause(),_(e).map(function(e){var t={action:"copy",id:e.id,folder:e.folder_id,timestamp:e.timestamp||_.then(),ignoreWarnings:o};return e.file_options&&e.file_options.params&&(t=_.extend(t,e.file_options.params)),l.PUT({module:"files",params:t,data:{folder_id:i},appendColumns:!1})}),l.resume({consolidate:"reject"})}function O(n,r,a,e){function i(e){for(var t,i=0,o=(e=_.isString(e)?[]:e)?e.length:0;i<o;i++)if(e[i].error&&"CONFLICT"!==e[i].error.categories){t=e[i].error.error;break}g.propagate(n,r,a),s.resolve(t||e)}function t(e){if(_.isArray(e)){for(var t=0;t<e.length;t++)if("CONFLICT"===e[t].error.categories)return void i(e)}else if("CONFLICT"===e.categories)return void i(e);s.reject(e)}var o="move"===n?P:z,s=$.Deferred();return l.wait(o(r,a,e)).then(function(e){"move"===n&&e&&e.length&&(e=_(e).map(function(e){return e.data&&e.data.job?void c.addJob({module:"folders",action:"update",done:!1,showIn:"infostore",id:e.data.job,successCallback:i,failCallback:t}):e}),0===(e=_(e).compact()).length)||i(e)},function(e){s.reject(e)}),s}function U(e,t,i){t=_.extend({addVersion:!0,folder:a.get("folder/infostore"),module:"files"},t);var o=_.extend({action:e,force_json_response:!0,timestamp:_.then()},t.params);t.filename&&(o.filename=t.filename),t.title&&(i.title=t.title),t.preview&&(i.meta=_.extend({},i.meta,{note_preview:t.preview})),"new"===e&&(o.extendedResponse=!0,o.try_add_version=!1!==t.addVersion,"newFile"===f.get("uploadHandling")&&(o.try_add_version=!1));e=new FormData;return e.append("json",JSON.stringify(i)),e.folder=i.folder_id,"filename"in t?e.append("file",t.file,t.filename):"file"in t&&e.append("file",t.file),l.UPLOAD({module:t.module,params:o,data:e,fixPost:!0}).fail(w)}function j(e){return l.pause(),g.get(e,{cache:!1}),g.versions.load(e,{cache:!1}),l.resume().then(function(e){return!(!_.isArray(e)||!e.length)&&e[0].data})}return s.on({"before:clear":function(e){var i=String(f.get("folder/trash"))===e;_(v.getByFolder(e)).each(function(e){var t=e.filter(function(e){return i||e.isFile()});e.length===t.length?e.reset():e.remove(t)})},"remove:infostore":function(){var e=f.get("folder/trash");e&&(s.list(e,{cache:!1}),_(v.getByFolder(e)).each(function(e){e.expired=!0})),k()},"before:remove before:move":function(e){var t=v.get("detail"),e=_.cid(e);t.remove(t.get(e))},restore:function(){g.trigger("refresh:listviews")}}),g.remove=function(e,t){return A(e),l.wait(l.PUT({module:"files",params:{action:"delete",timestamp:_.then(),hardDelete:Boolean(t)},data:l.simplify(e),appendColumns:!1}).done(function(){g.propagate("remove:file",e)}))},g.move=function(e,t,i){return A(e),O("move",e,t,i)},g.copy=function(e,t,i){return O("copy",e,t,i)},g.zip=function(t){return require(["io.ox/core/download"]).then(function(e){e.url(ox.apiRoot+"/files?"+$.param({action:"zipfolder",folder:t,recursive:!0,session:ox.session}))})},g.update=function(t,e,i){if(_.isObject(e)&&!_.isEmpty(e)){var o=g.pool.get("detail").get(_.cid(t)),n={};o&&(o.set(e),r=Object.keys(o.changedAttributes()),_.each(r,function(e){n[e]=o.previous(e)})),i=_.extend({silent:!1},i);var r={file:e};return i.notification&&!_.isEmpty(i.notification)&&(r.notification=i.notification),l.PUT({module:"files",params:{action:"update",id:t.id,timestamp:_.then(),ignoreWarnings:i.ignoreWarnings,extendedResponse:!0},data:r,appendColumns:!1}).then(function(e){_.isObject(e)&&o&&(o.set("id",e.id),t.id=e.id,o.set("com.openexchange.file.sanitizedFilename",e["com.openexchange.file.sanitizedFilename"]),t["com.openexchange.file.sanitizedFilename"]=e["com.openexchange.file.sanitizedFilename"])}).always(_.lfo(function(e,t,i){i&&i.error&&e&&t&&t.set(e)},n,o)).done(function(){i.silent||g.propagate("change:file",t,e)})}},g.upload=function(n){var e=n.folder_id||n.folder,t=U("new",n,{folder_id:e,description:n.description||""}),e=t.then(function(e){var t=e.data.file,i=_(t).pick("id","folder_id"),o=t.title||t.filename;if("new_version"!==e.data.save_action)return g.propagate("add:file",i),t;i=g.pool.get("detail").get(_.cid(i));return i&&i.set("id",t.id),!1!==n.addVersion&&"new_version"===e.data.save_action&&"announceNewVersion"===f.get("uploadHandling")&&g.trigger("add:imp_version",o),g.propagate("add:version",t)});return e.abort=t.abort,e},g.versions={upload:function(i){var e=U("update",i,{id:i.id,folder_id:i.folder_id||i.folder,version_comment:i.version_comment||""}),t=e.then(function(e){var t=e.data;if(i.id===t)return g.propagate("add:version",i);e=g.pool.get("detail").get(_.cid(i));return e.set("id",t),g.propagate("add:version",e.toJSON())});return t.abort=e.abort,t},load:function(e,i){i=_.extend({cache:!0,adjustVersion:!1},i);var t=_.cid(e),o=v.get("detail").get(t);return o?i.cache&&o.has("versions")?$.when(o.get("versions")):l.GET({module:"files",params:{action:"versions",columns:y,folder:e.folder_id,id:e.id,timezone:"utc"},appendColumns:!0}).then(function(e){var t={versions:e,number_of_versions:e.length};return null===o.get("version")&&i.adjustVersion&&(t.version=null,_.last(e).version=null),o.set(t),e}):$.when([])},remove:function(t){var e=_.cid(t),e=v.get("detail").get(e);return e&&_.isArray(e.get("versions"))&&e.set("versions",e.get("versions").filter(function(e){return e.version!==t.version})),l.PUT({module:"files",params:{action:"detach",id:t.id,folder:t.folder_id,timestamp:_.then()},data:[t.version],appendColumns:!1}).then(function(){return g.propagate("remove:version",t)})},removePreviousVersions:function(t){var i,e=v.get("detail").get(_.cid(t)),o=e.get("versions");return o.sort(function(e,t){return e.current_version?-o.length:t.current_version?o.length:t.last_modified-e.last_modified}),e&&_.isArray(o)&&e.set("versions",o.filter(function(e){return e.version===t.version?i=!0:!!e.current_version||!(parseInt(e.version,10)<parseInt(t.version,10))&&!i})),l.PUT({module:"files",params:{action:"detach",id:t.id,folder:t.folder_id,timestamp:_.then()},data:_.difference(o,e.get("versions")).map(function(e){return e.version}),appendColumns:!1}).then(function(){g.propagate("refresh:file",_.pick(t,"id","folder_id"))})},setCurrent:function(t){var e=v.get("detail").get(_.cid(t));e&&_.isArray(e.get("versions"))&&e.set("versions",e.get("versions").map(function(e){return e.current_version=e.version===t.version,e}));e={version:t.version};return g.update(t,e).done(function(){g.propagate("change:version",t)})},getCurrentState:function(i,e){return"boolean"==typeof i.current_version?$.when(i.current_version):g.versions.load(i,e).then(function(e){var t=!1;return t=_.isArray(e)?!e.length||_.some(e,function(e){return!!e.current_version&&(-1===e.number_of_versions||e.version===i.version)}):t})},mustEncryptNewVersion:function(e,t){t=g.isGuardExtension({filename:t});return e.isEncrypted()&&!t}},g.search=function(e,t){return t=_.extend({action:"search",columns:g.search.columns,sort:"702",order:"asc",limit:100},t),l.PUT({module:"files",params:_(t).pick("action","columns","sort","order","limit","folder","includeSubfolders"),data:g.search.getData(e,t)}).done(function(e){_(e).each(T)})},g.search.columns=x,g.search.getData=function(e){return{pattern:e}},g.propagate=(C={new:"add:file",change:"change:file",update:"change:file",delete:"remove:file"},function(e,t){var i=_.isArray(t)?t:[t];switch(s.isExternalFileStorage(t),t=_(t).pick("folder","folder_id","id","version"),e=C[e]||e,ox.debug&&console.log("files/api.propagate()",e,t,i,arguments[2]||{}),e){case"add:file":g.trigger("add:file",t),s.reload(i);break;case"restore:fail":g.trigger("restore:fail",t);break;case"add:version":case"refresh:file":return j(t).done(function(){g.trigger("add:version",t)});case"change:file":g.trigger("change:file update change:file:"+_.ecid(t)+" update:"+_.ecid(t));var o=arguments[2]||{};("title"in o||"filename"in o)&&g.propagate("rename",t),"object_permissions"in o&&g.propagate("permissions",t),"description"in o&&g.propagate("description",t);break;case"favorite:add":g.trigger("favorite:add",t);break;case"favorite:remove":g.trigger("favorite:remove",t);break;case"change:version":g.trigger("change:version",t);break;case"clear":g.trigger("clear",t.folder_id),s.reload(t.folder_id);break;case"copy":case"move":var i=_.reject(i,function(e){return"folder"===e.folder_id}),n=arguments[2];g.trigger(e,i,n),s.reload(i,n),v.resetFolder(n);break;case"lock":return g.getList(i,{cache:!1});case"remove:file":s.reload(i);n=f.get("folder/trash");n&&_(v.getByFolder(n)).each(function(e){e.expired=!0}),g.trigger("remove:file",i),_(i).each(function(e){g.trigger("remove:file:"+_.ecid(e))});break;case"remove:version":return j(t).done(function(){g.trigger("remove:version",t)});case"rename":return s.get(t.folder_id).then(function(e){return s.isExternalFileStorage(e)?j(t).done(function(){g.trigger("rename",_.cid(t))}):void g.trigger("rename",_.cid(t))});case"permissions":g.trigger("change:permissions",_.cid(t));break;case"description":g.trigger("description",_.cid(t))}}),g.getDefaultColumns=function(e){var t=l.getAllColumns("files");return _([].concat(t,e)).uniq().sort().join(",")},g});