/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.api.contenttypes.transferhandlers;

import java.util.BitSet;
import com.openexchange.usm.api.contenttypes.folder.OXFolderContent;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObjectFilter;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.api.session.Session;

/**
 * Handler for the entire interaction with the OX server for the Folder Content Type.
 * 
 * @author ldo
 */
public interface FolderContentTypeTransferHandler extends ContentTypeTransferHandler {

    String MODULE_SYSTEM = "system";

    /**
     * Same as readDataObject, but uses the more specific interface Folder for its parameter.
     * 
     * @param object
     * @param requestedFields
     * @throws USMException
     */
    void readFolder(Folder object, BitSet requestedFields) throws USMException;

    /**
     * Defines more specific return type than generic interface
     * 
     * @param object
     * @throws USMException
     */
    @Override
    Folder[] readFolderContent(Folder folder) throws USMException;

    /**
     * Defines more specific return type than generic interface
     * 
     * @param object
     * @param limit
     * @param filter
     * @throws USMException
     */
    @Override
    OXFolderContent readFolderContent(Folder folder, int limit, DataObjectFilter filter) throws USMException;

    /**
     * Defines more specific return type than generic interface
     * 
     * @param object
     * @param requestedFields
     * @throws USMException
     */
    @Override
    Folder[] readFolderContent(Folder folder, BitSet requestedFields) throws USMException;

    /**
     * Defines more specific return type than generic interface
     * 
     * @param folder
     * @param requestedFields
     * @param timestamp
     * @throws USMException
     */
    @Override
    Folder[] readUpdatedFolderContent(Folder folder, BitSet requestedFields, long timestamp) throws USMException;

    /**
     * Same as writeDeletedDataObject, but uses the more specific interface Folder for its parameter.
     * 
     * @param object
     * @throws USMException
     */
    void writeDeletedFolder(Folder object) throws USMException;

    /**
     * Same as writeNewDataObject, but uses the more specific interface Folder for its parameter.
     * 
     * @param object
     * @throws USMException
     */
    void writeNewFolder(Folder object) throws USMException;

    /**
     * Same as writeUpdatedDataObject, but uses the more specific interface Folder for its parameter.
     * 
     * @param object
     * @throws USMException
     */
    void writeUpdatedFolder(Folder object, long timestamp) throws USMException;

    /**
     * Additional method for Folder ContentType that provides all root folders.
     * 
     * @param session
     * @param requestedFields
     * @return
     * @throws USMException
     */
    Folder[] readRootFolders(Session session, BitSet requestedFields) throws USMException;
}
