package com.openexchange.office.tools.osgi;

import java.util.Dictionary;

import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;

import com.openexchange.office.tools.logging.LogFactory;
import com.openexchange.osgi.HousekeepingActivator;

//=============================================================================
public class ActivatorCore extends HousekeepingActivator
{
	//-------------------------------------------------------------------------
	public static final Logger LOG = LogFactory.getSlfLog (ActivatorCore.class);

	//-------------------------------------------------------------------------
	public ActivatorCore ()
	{}

	//-------------------------------------------------------------------------   
	public synchronized void setBundleName (final String sBundleName)
		throws Exception
	{
		m_sBundleName = sBundleName;
	}
	
	//-------------------------------------------------------------------------   
	public synchronized void setBinding (final IActivatorCoreBinding iBinding)
	    throws Exception
	{
		m_iBinding = iBinding;
	}
	
	//-------------------------------------------------------------------------   
	public synchronized void setMandatoryServiceImports (final Class< ? >[] lServices)
		throws Exception
	{
		m_lMandatoryServiceImports = lServices;
	}
	
	//-------------------------------------------------------------------------   
	public synchronized void setOptionalServiceImports (final Class< ? >[] lServices)
		throws Exception
	{
		m_lOptionalServiceImports = lServices;
	}

	//-------------------------------------------------------------------------   
	@Override
	protected synchronized Class< ? >[] getNeededServices()
	{
		LOG.trace("["+m_sBundleName+"] core : get needed services");
		if (m_lMandatoryServiceImports == null)
			m_lMandatoryServiceImports = new Class< ? >[0];
		return m_lMandatoryServiceImports;
	}

	//-------------------------------------------------------------------------   
	@Override
	protected synchronized Class< ? >[] getOptionalServices()
	{
		LOG.trace("["+m_sBundleName+"] core : get optional services");
		if (m_lOptionalServiceImports == null)
			m_lOptionalServiceImports = new Class< ? >[0];
		return m_lOptionalServiceImports;
	}

	//-------------------------------------------------------------------------   
	@Override
	protected /* no synchronized */ void startBundle()
		throws Exception
	{
		LOG.trace("["+m_sBundleName+"] core : start bundle");
		
		IActivatorCoreBinding iBinding = null;
		synchronized (this)
		{
			iBinding = m_iBinding;
		}
		
		iBinding.inActivate();
	}

	//-------------------------------------------------------------------------   
	@Override
	protected /* no synchronized */ void stopBundle()
		throws Exception
	{
		LOG.trace("["+m_sBundleName+"] core : stop bundle");
		
		IActivatorCoreBinding iBinding = null;
		synchronized (this)
		{
			iBinding = m_iBinding;
		}

		iBinding.inDeactivate();
	}

	//-------------------------------------------------------------------------
	@Override
	protected /* no synchronized */ void handleUnavailability(final Class< ? > aService)
	{
		try
		{
			LOG.trace("["+m_sBundleName+"] core : service '"+aService+"' is unavailable");
			IActivatorCoreBinding iBinding = null;
			synchronized (this)
			{
				iBinding = m_iBinding;
			}
			iBinding.serviceIsUnavailable(aService);
		}
		catch (Throwable ex)
		{
			LOG.error (ex.getMessage(), ex);
			throw new RuntimeException (ex);
		}
	}	

	//-------------------------------------------------------------------------
	@Override
	protected /* no synchronized */ void handleAvailability(final Class< ? > aService)
	{
		try
		{
			LOG.trace("["+m_sBundleName+"] core : service '"+aService+"' is available");
			IActivatorCoreBinding iBinding = null;
			synchronized (this)
			{
				iBinding = m_iBinding;
			}
			iBinding.serviceIsAvailable(aService);
		}
		catch (Throwable ex)
		{
			LOG.error (ex.getMessage(), ex);
			throw new RuntimeException (ex);
		}
	}
	
	//-------------------------------------------------------------------------   
	public /* no synchronized */ boolean allServciesAvailable ()
	    throws Exception
	{
		return super.allAvailable();
	}
	
	//-------------------------------------------------------------------------   
	@Override
	public /* no synchronized */ void openTrackers()
	{
		LOG.trace("["+m_sBundleName+"] core : open trackers");
		super.openTrackers();
	}

	//-------------------------------------------------------------------------   
	@Override
	public /* no synchronized */ void closeTrackers()
	{
		LOG.trace("["+m_sBundleName+"] core : close trackers");
		super.closeTrackers();
	}

    //-------------------------------------------------------------------------
	@Override
    public /* no synchronized */ < S > void registerService(final Class< S >              aService   ,
    								  					    final S                       aInstance  ,
    								  					    final Dictionary< String, ? > aDictionary)
    {
		LOG.trace("["+m_sBundleName+"] core : register service '"+aService+"' for instance '"+aInstance+"'");
		super.registerService(aService, aInstance, aDictionary);
    }

    //-------------------------------------------------------------------------   
	@Override
	public /* no synchronized */ < S > ServiceRegistration< S > getServiceRegistrationFor(final Class< S > aService)
	{
		return super.getServiceRegistrationFor(aService);
	}

	//-------------------------------------------------------------------------   
	private String m_sBundleName = null;
	
	//-------------------------------------------------------------------------   
	private IActivatorCoreBinding m_iBinding = null;
	
	//-------------------------------------------------------------------------   
	private Class< ? >[] m_lMandatoryServiceImports = null;

	//-------------------------------------------------------------------------   
	private Class< ? >[] m_lOptionalServiceImports = null;
}