
package com.openexchange.office.spellchecker.rest;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.office.spellchecker.api.ISpellChecker;
import com.openexchange.office.tools.osgi.ServiceLookupRegistry;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;

/**
 * {@link SpellWordReplacementsAction}
 *
 * @author <a href="mailto:oliver.specht@open-xchange.com">Oliver Specht</a>
 */
/*
 * @Action(method = RequestMethod.GET, name = "exportdocument", description =
 * "Save the requested document after merging in the given operations.", parameters = {
 * @Parameter(name = "session", description = "A session ID previously obtained from the login module."),
 * @Parameter(name = "id", description = "Object ID of the requested infoitem."),
 * @Parameter(name = "folder_id", description = "Folder ID of the requested infoitem."),
 * @Parameter(name = "uid", description = "The unique id of the client application."),
 * @Parameter(name = "version", optional = true, description =
 * "If present, the infoitem data describes the given version. Otherwise the current version is used."), }, responseDescription = "None.")
 */
public class SpellWordReplacementsAction implements AJAXActionService {

    /**
     * Initializes a new {@link SpellWordReplacementsAction}.
     *
     * @param services
     */
    public SpellWordReplacementsAction(ServiceLookup servicesDEPRECATED) {
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {

        AJAXRequestResult requestResult = new AJAXRequestResult();
        final JSONObject spellResult = new JSONObject();

        String wordToCheck = request.getParameter("word");
        String locale = request.getParameter("locale");
        final ISpellChecker iSpellChecker = ServiceLookupRegistry.get().getService(ISpellChecker.class);
        if (iSpellChecker != null && wordToCheck != null && locale != null && wordToCheck.length() > 0) {
            try {
                spellResult.put("SpellReplacements", iSpellChecker.suggestReplacements(wordToCheck, locale));
            } catch (JSONException e) {
                ;
            }
        }
        requestResult.setResultObject(spellResult);
        return requestResult;
    }

}
