/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.realtime.osgi;

import java.util.List;

import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;

import com.openexchange.ajax.requesthandler.crypto.CryptographicServiceAuthenticationFactory;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.context.ContextService;
import com.openexchange.conversion.simple.SimplePayloadConverter;
import com.openexchange.documentconverter.IDocumentConverter;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.file.storage.composition.crypto.CryptographicAwareIDBasedFileAccessFactory;
import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.guard.api.GuardApi;
import com.openexchange.jslob.JSlobService;
import com.openexchange.office.backup.manager.DocumentBackupController;
import com.openexchange.office.hazelcast.doc.DocSaveStateDirectory;
import com.openexchange.office.hazelcast.doc.DocumentDirectory;
import com.openexchange.office.realtime.impl.ConnectionBackgroundProcessorManager;
import com.openexchange.office.realtime.impl.ConnectionComponent;
import com.openexchange.office.realtime.impl.FailSafeSaveProcessor;
import com.openexchange.office.realtime.impl.calc.CalcComponent;
import com.openexchange.office.realtime.impl.presentation.PresentationComponent;
import com.openexchange.office.realtime.impl.text.TextComponent;
import com.openexchange.office.realtime.tools.JSON2MessageData;
import com.openexchange.office.realtime.tools.MessageData2JSON;
import com.openexchange.office.templatemgr.api.IResourceProvider;
import com.openexchange.office.tools.logging.LogFactory;
import com.openexchange.office.tools.osgi.ActivatorBase;
import com.openexchange.realtime.Component;
import com.openexchange.realtime.cleanup.GlobalRealtimeCleanup;
import com.openexchange.realtime.cleanup.RealtimeJanitor;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.timer.TimerService;
import com.openexchange.user.UserService;

//=============================================================================
public class ConnectionActivator extends ActivatorBase
{
	//-------------------------------------------------------------------------   
    private static final String SERVICE_NAME = "com.openexchange.office.realtime";

    //-------------------------------------------------------------------------   
    private static final Logger LOG = LogFactory.getSlfLog(ConnectionActivator.class);

	//-------------------------------------------------------------------------   
    public ConnectionActivator ()
        throws Exception
    {
    	super (SERVICE_NAME);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void listMandatoryServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
    	lServices.add (com.openexchange.office.filter.odf.       Importer                  .class);
    	lServices.add (com.openexchange.office.filter.odf.       Exporter                  .class);
    	lServices.add (com.openexchange.office.filter.ooxml.pptx.Importer                  .class);
    	lServices.add (com.openexchange.office.filter.ooxml.pptx.Exporter                  .class);
    	lServices.add (com.openexchange.office.filter.ooxml.docx.Importer                  .class);
    	lServices.add (com.openexchange.office.filter.ooxml.docx.Exporter                  .class);
    	lServices.add (com.openexchange.office.filter.ooxml.xlsx.Importer                  .class);
    	lServices.add (com.openexchange.office.filter.ooxml.xlsx.Exporter                  .class);
    	lServices.add (                                          IResourceProvider         .class);
    	lServices.add (                                          ConfigurationService      .class);
    	lServices.add (                                          CapabilityService         .class);
    	lServices.add (                                          IDBasedFileAccessFactory  .class);
    	lServices.add (                                          IDBasedFolderAccessFactory.class);
    	lServices.add (                                          FolderService             .class);
        lServices.add (                                          ManagedFileManagement     .class);
        lServices.add (                                          DistributedFileManagement .class);
        lServices.add (                                          UserService               .class);
        lServices.add (                                          TimerService              .class);
        lServices.add (com.openexchange.sessiond.                SessiondService           .class);
        lServices.add (                                          GlobalRealtimeCleanup     .class);
        lServices.add (                                          JSlobService              .class);
        lServices.add (                                          ThreadPoolService         .class);
        lServices.add (                                          ContextService            .class);
        lServices.add (                                          DocumentDirectory         .class);
        lServices.add (                                          DocSaveStateDirectory     .class);
        lServices.add (                                          DocumentBackupController  .class);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void listOptionalServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
        lServices.add(IDocumentConverter                        .class);
        lServices.add(CryptographicAwareIDBasedFileAccessFactory.class);
        lServices.add(CryptographicServiceAuthenticationFactory .class);
        lServices.add(GuardApi                                  .class);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void activate()
    	throws Exception
    {
		// Register the components
		registerService(Component.class, textComponent = new TextComponent(null));
		registerService(Component.class, calcComponent = new CalcComponent(null));
		registerService(Component.class, presComponent = new PresentationComponent(null));

		// Register the components as RealtimeJanitor that can be tracked via OSGI and used when a cleanup is needed
		registerService(RealtimeJanitor.class, textComponent, textComponent.getServiceProperties());
		registerService(RealtimeJanitor.class, calcComponent, calcComponent.getServiceProperties());
		registerService(RealtimeJanitor.class, presComponent, presComponent.getServiceProperties());

		// You have to provide these converters if you want to put non JSON classes into
		// Payload trees.
		// Also, if you want to receive non-json data, which is usually very convenient, you
		// can declare that a payload with a certain namespace and element name should always be
		// Converted into a specific format. For that see the PayloadTreeConverter interface
		registerService(SimplePayloadConverter.class, new MessageData2JSON());
		registerService(SimplePayloadConverter.class, new JSON2MessageData());
		
		// Register document specific background processor dependent on
		// configuration entries.
		final ConfigurationService configuration = getService(ConfigurationService.class);
		boolean backgroundSave = configuration.getBoolProperty("io.ox/office//module/backgroundSaveDoc", true);
		LOG.debug("Background document save = " + backgroundSave);
		if (backgroundSave)
		{
		    m_backgroundProcesses = new ConnectionBackgroundProcessorManager(null);
		    final FailSafeSaveProcessor failSafeSaveProcessor = new FailSafeSaveProcessor(null);
		    m_backgroundProcesses.registerProcessor(failSafeSaveProcessor);
		    // only add connection pool if we know that at least one processor has been added
		    m_backgroundProcesses.addConnectionPool(textComponent);
		    m_backgroundProcesses.addConnectionPool(calcComponent);
		    m_backgroundProcesses.addConnectionPool(presComponent);
		    m_backgroundProcesses.start();
		}
    }

    //------------------------------------------------------------------------- 
    @Override
    protected void deactivate()
    	throws Exception
    {
        if (null != m_backgroundProcesses) {
            m_backgroundProcesses.shutdown();
            m_backgroundProcesses = null;
        }
        if (null != textComponent) {
            textComponent.shutdown();
            textComponent = null;
        }
        if (null != calcComponent) {
            calcComponent.shutdown();
            calcComponent = null;
        }
        if (null != presComponent) {
            presComponent.shutdown();
            presComponent = null;
        }
    }

    //------------------------------------------------------------------------- 
    private ConnectionBackgroundProcessorManager m_backgroundProcesses = null;

    //------------------------------------------------------------------------- 
    private ConnectionComponent textComponent = null;

    //------------------------------------------------------------------------- 
    private ConnectionComponent calcComponent = null;

    //------------------------------------------------------------------------- 
    private ConnectionComponent presComponent = null;
}
