/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.presenter.rt;

import java.util.Iterator;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.presenter.impl.ConnectionStatus;
import com.openexchange.realtime.packet.ID;
import com.openexchange.realtime.packet.Stanza;
import com.openexchange.realtime.payload.PayloadTree;
import com.openexchange.realtime.util.ElementPath;


/**
 * {@link OperationsMessage}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class MessageData {

    /**
     * Initializes a new {@link MessageData}.
     * @param operationsChunk
     * @param queueStatus
     */
    public MessageData(ConnectionStatus connectionStatus) {
        super();

        this.m_connectionStatus = connectionStatus;
    }

    /**
     * Initializes a new {@link MessageData}.
     * @param operationsChunk
     * @param queueStatus
     * @param clientId
     */
    public MessageData(ConnectionStatus connectionStatus, JSONObject jsonData) {
        super();

        this.m_connectionStatus = connectionStatus;
        this.m_jsonData = jsonData;
    }

    /**
     * @return
     */
    public JSONObject toJSON() {
        final JSONObject ret = new JSONObject();

        if (null != m_connectionStatus) {
            appendJSON(ret, m_connectionStatus.toJSON());
        }

        if (null != m_jsonData) {
            appendJSON(ret, m_jsonData);
        }

        return ret;
    }

    /**
     * @param jsonData
     * @return
     */
    static public MessageData createFrom(JSONObject jsonData, ID sender) {
        final ConnectionStatus queueStatus = ConnectionStatus.createFrom(jsonData);

        return new MessageData(queueStatus, jsonData);
    }

    static private void appendJSON(final JSONObject target, final JSONObject source) {
        final Iterator<String> keys = source.keys();

        try {
            while (keys.hasNext()) {
                final String curKey = keys.next();
                final Object curObject = source.get(curKey);
                target.put(curKey, curObject);
            }
        } catch (JSONException e) {
            //LOG.error("RT connection: Exception caught while setting up JSON result within appendJSONElement", e);
        }
    }
    
    static public final JSONObject getJSONRequest(Stanza stanza, ElementPath elementPath) {
        final JSONObject jsonRequest = new JSONObject();

        // We're iterating over all messages that are constructed with the office.operations element path
        for (final PayloadTree payload : stanza.getPayloadTrees(elementPath)) {
            final Object data = payload.getRoot().getData();

            if (data instanceof JSONObject) {
                appendJSON(jsonRequest, (JSONObject)data);
            }
        }

        return jsonRequest;
    }
    
    // - Member ----------------------------------------------------------------
    private ConnectionStatus m_connectionStatus = null;
    private JSONObject m_jsonData = null;
}
