package com.openexchange.office.htmldoc;

public class Tab
        extends SubNode
{

    private static final String BEFOREATTRS = "<div contenteditable=\"false\" class=\"inline tab\"><span ";
    private static final String AFTERATTRS  = " >&nbsp</span></div>";

    // ///////////////////////////////////////////////////////////

    public Tab(
            int position)
    {
        super(position, 1);
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(BEFOREATTRS);

        GenDocHelper.appendAttributes(getAttribute(), document);

        document.append(AFTERATTRS);
        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }
}
