package com.openexchange.office.htmldoc;

import org.json.JSONObject;

public class CommentPlaceHolder
        extends SubNode
{

    private static final String PLACEHOLDERSTART = "<div contenteditable=\"false\" class=\"inline commentplaceholder\" data-container-id=\"";
    private static final String PLACEHOLDERCLOSER = "\"";
    private static final String PLACEHOLDEREND = "></div>";

    private String              id;

    // ///////////////////////////////////////////////////////////

    public CommentPlaceHolder(
            int position, String id)
    {
        super(position, 1);

        this.id = id;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(PLACEHOLDERSTART + GenDocHelper.escapeUIString(this.id) + PLACEHOLDERCLOSER);

        JSONObject params = new JSONObject();
        params.put("containerId", id);

        document.append(" jquerydata='");
        document.append(params.toString());
        document.append("'");
        document.append(PLACEHOLDEREND);

        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public String toString()
    {
        return "CommentPlaceHolder";
    }

}
