
package com.openexchange.office.htmldoc;

public class Bookmark extends SubNode {

    private final String bmId;
    private final String anchor;
    private final String bmPos;

    public Bookmark(int subPos, String id, String anchorName, String position) {
        super(subPos, 1);

        this.bmId = id;
        this.anchor = anchorName;
        this.bmPos = position;
    }

    @Override
    public boolean appendContent(StringBuilder document) throws Exception {
        document.append("<div contenteditable=\"false\" class=\"bookmark inline\" ");

        String anchorStr = GenDocHelper.escapeUIString(this.anchor);
        String bmIdStr = GenDocHelper.escapeUIString(this.bmId);
        String bmPosStr = GenDocHelper.escapeUIString(this.bmPos);

        document.append("anchor=\"" + anchorStr + "\" ");
        document.append("bmId=\"" + bmIdStr + "\" ");
        document.append("bmPos=\"" + bmPosStr + "\" ");

        GenDocHelper.appendAttributes(getAttribute(), document);

        document.append(" ></div>");
        return true;
    }

    @Override
    public boolean needsEmptySpan() {
        return true;
    }

}
