package com.openexchange.office.hazelcast.doc;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.openexchange.exception.OXException;
import com.openexchange.management.ManagementAware;
import com.openexchange.management.ManagementObject;
import com.openexchange.office.hazelcast.access.HazelcastAccess;
import com.openexchange.office.hazelcast.management.HazelcastDocumentCleanupLockMBean;
import com.openexchange.office.hazelcast.management.HazelcastDocumentCleanupLockManagement;
import com.openexchange.office.hazelcast.serialization.document.PortableCleanupStatus;

public class HazelcastDocumentCleanupLock implements ManagementAware<HazelcastDocumentCleanupLockMBean> {

    private final String mapIdentifier;
    private final ManagementObject<HazelcastDocumentCleanupLockMBean> managementObject;

    public HazelcastDocumentCleanupLock(final String mapIdentifier) {
        this.mapIdentifier = mapIdentifier;
        this.managementObject = new HazelcastDocumentCleanupLockManagement(this);
    }

    @Override
    public ManagementObject<HazelcastDocumentCleanupLockMBean> getManagementObject() {
        return managementObject;
    }

    /**
     * Get the mapping of full IDs to the Resource e.g. ox://marc.arens@premium/random <-> Resource. The resource includes the
     * {@link RoutingInfo} needed to address clients identified by the {@link ID}
     *
     * @return the map used for mapping full IDs to ResourceMaps.
     * @throws OXException if the map couldn't be fetched from hazelcast
     */
    public IMap<String, PortableCleanupStatus> getCleanupLockMapping() throws OXException {
        HazelcastInstance hazelcast = HazelcastAccess.getHazelcastInstance();
        return hazelcast.getMap(mapIdentifier);
    }
}
