/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.operations;

import org.docx4j.dml.BaseStyles.FontScheme;
import org.docx4j.dml.CTColorMapping;
import org.docx4j.dml.CTColorScheme;
import org.docx4j.dml.FontCollection;
import org.docx4j.dml.STColorSchemeIndex;
import org.docx4j.dml.Theme;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.ooxml.OperationDocument;
import com.openexchange.office.filter.ooxml.tools.Commons;
import com.openexchange.office.filter.ooxml.tools.ThemeFonts;

abstract public class CreateOperationHelper {

    protected final OperationDocument operationDocument;
    protected JSONArray operationsArray;
    protected int jsonLogSize;

    protected CreateOperationHelper(OperationDocument _operationDocument, JSONArray _operationsArray)
    	throws FilterException {

    	operationDocument = _operationDocument;
        operationsArray = _operationsArray;
        jsonLogSize = 0;
    }

    abstract public OperationDocument getOperationDocument();

    abstract public void createDocumentDefaults(String userLanguage)
    	throws InvalidFormatException, JSONException;

    private void putSchemeColor(final JSONObject jsonColorScheme, final String colorKey, final CTColorScheme colorScheme, final CTColorMapping colorMapping)
        throws JSONException {
        jsonColorScheme.put(colorKey, Commons.ctColorToString(colorScheme.getByColorKey(colorKey, colorMapping)));
    }

    private void putSchemeFont(final JSONObject jsonFontScheme, final String fontKey, final FontCollection schemeFont)
        throws JSONException {
        if (schemeFont != null) { jsonFontScheme.put(fontKey, schemeFont.getLatin().getTypeface()); }
    }

    public void createThemeOperations(String target, CTColorMapping colorMapping)
        throws FilterException, JSONException {

    	final Theme theme = getOperationDocument().getThemePart(true).getJaxbElement();

        final CTColorScheme colorScheme = theme.getThemeElements().getClrScheme();
        final JSONObject jsonColorScheme = new JSONObject();
        putSchemeColor(jsonColorScheme, "dark1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "dark2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "light1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "light2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "text1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "text2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "background1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "background2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent3", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent4", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent5", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent6", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "hyperlink", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "followedHyperlink", colorScheme, colorMapping);

        final FontScheme fontScheme = theme.getThemeElements().getFontScheme();
        final JSONObject jsonFontScheme = new JSONObject(2);
        putSchemeFont(jsonFontScheme, ThemeFonts.MAJOR_ID, fontScheme.getMajorFont());
        putSchemeFont(jsonFontScheme, ThemeFonts.MINOR_ID, fontScheme.getMinorFont());

        addInsertThemeOperation(theme.getName(), jsonColorScheme, jsonFontScheme, target);
    }

    public JSONArray getOperationsArray() {
    	return operationsArray;
    }

    public void setOperationsArray(JSONArray _operationsArray) {
    	operationsArray = _operationsArray;
    }

    public void addSetDocumentAttributesOperation(JSONObject attrs)
        throws JSONException {

        if(attrs!=null&&attrs.length()>0) {
            final JSONObject setDocumentAttributesObject = new JSONObject(2);
            setDocumentAttributesObject.put("name", "setDocumentAttributes");
            setDocumentAttributesObject.put("attrs", attrs);
            operationsArray.put(setDocumentAttributesObject);
        }
    }

    public void addInsertThemeOperation(String themeName, JSONObject clrScheme, JSONObject fontScheme, String target)
        throws JSONException {

        final JSONObject insertThemeObject = new JSONObject(5);
        insertThemeObject.put("name", "insertTheme");
        insertThemeObject.put("themeName", themeName);
        insertThemeObject.put("colorScheme", clrScheme);
        insertThemeObject.put("fontScheme", fontScheme);
        if(target!=null) {
        	insertThemeObject.put("target", target);
        }
        operationsArray.put(insertThemeObject);
    }

    public JSONObject createInsertStyleSheetOperation(String type, String styleId, String styleName, JSONObject attrs, String parentId, Boolean hidden, Integer uipriority, Boolean isDefault, Boolean custom)
        throws JSONException {

        final JSONObject insertStylesheetObject = new JSONObject();
        insertStylesheetObject.put("name", "insertStyleSheet");
        insertStylesheetObject.put("type", type);
        insertStylesheetObject.put("styleId", styleId);
        insertStylesheetObject.put("styleName", styleName);
        if(attrs!=null)
            insertStylesheetObject.put("attrs", attrs);
        if(parentId!=null&&parentId.length()>0)
            insertStylesheetObject.put("parent", parentId);
        if(hidden!=null)
            insertStylesheetObject.put("hidden", hidden);
        if(uipriority!=null)
            insertStylesheetObject.put("uiPriority", uipriority);
        if(isDefault!=null&&isDefault)
            insertStylesheetObject.put("default", true);
        if(custom!=null) {
            insertStylesheetObject.put("custom", custom);
        }
        return insertStylesheetObject;
    }

    public JSONObject createInsertAutoStyleOperation(String type, String styleId, JSONObject attrs, boolean isDefault)
        throws JSONException {

        final JSONObject insertStylesheetObject = new JSONObject(5);
        insertStylesheetObject.put("name", "insertAutoStyle");
        insertStylesheetObject.put("type", type);
        insertStylesheetObject.put("styleId", styleId);
        if(attrs!=null)
            insertStylesheetObject.put("attrs", attrs);
        if(isDefault)
            insertStylesheetObject.put("default", true);
        return insertStylesheetObject;
    }
}
