package com.openexchange.office.filter.ooxml.drawingml;

import java.util.HashMap;
import java.util.List;
import org.docx4j.dml.chartex2014.CTChartSpace;
import org.docx4j.dml.chartex2014.CTFormula;
import org.docx4j.dml.chartex2014.CTSeries;
import org.docx4j.dml.chartex2014.IDimension;
import org.docx4j.dml.chartex2014.STSeriesLayout;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.ooxml.tools.Commons;

public class DMLChartSpace2014 {

    public static void getChartType(ChartWrapper chart, HashMap<String, Object> map) {
        CTChartSpace space = chart.getChartPart2014().getContents();
        List<CTSeries> series = space.getChart().getPlotArea().getPlotAreaRegion().getSeries();

        STSeriesLayout type = series.get(0).getLayoutId();
        map.put("chartType", type.value());
    }

    public static void createChartSpaceOperations(JSONArray operationsArray, List<Integer> position, ChartWrapper chart) throws JSONException {
        CTChartSpace space = chart.getChartPart2014().getContents();
        List<CTSeries> series = space.getChart().getPlotArea().getPlotAreaRegion().getSeries();

        List<Object> data = space.getChartData().getData().get(0).getNumDimOrStrDim();

        String names = null;
        String values = null;

        for (Object d : data) {
            if (d instanceof IDimension) {
                IDimension dim = (IDimension) d;

                CTFormula f = (CTFormula) dim.getContent().get(0).getValue();

                if ("cat".equals(dim.getDimensionType())) {
                    names = f.getValue();
                } else if ("size".equals(dim.getDimensionType())) {
                    values = f.getValue();
                } else if ("val".equals(dim.getDimensionType())) {
                    values = f.getValue();
                }
            }
        }

        JSONObject shape = new JSONObject();
        shape.put("type", "solid");

        for (int i = 0; i < series.size(); i++) {
            CTSeries serie = series.get(i);

            JSONObject json = new JSONObject();
            json.putSafe("type", serie.getLayoutId().value());
            json.putSafe("names", names);
            json.putSafe("values", values);

            final JSONObject attrs = Commons.surroundJSONObject("series", json);

            attrs.put("fill", shape);
            attrs.put("line", shape);

            JSONObject op = new JSONObject();
            op.put("name", "insertChartDataSeries");
            op.put("start", position);
            op.put("series", i);
            op.put("attrs", attrs);
            operationsArray.put(op);
        }

    }

    public static void setDataSeriesAttributes(ChartWrapper chart, int seriesIndex, JSONObject attrs) throws JSONException {

        final JSONObject attrSeries = attrs.optJSONObject("series");
        if (attrSeries != null) {

            if (seriesIndex == 0) {
                CTChartSpace space = chart.getChartPart2014().getContents();
                List<Object> data = space.getChartData().getData().get(0).getNumDimOrStrDim();


                for (Object d : data) {
                    if (d instanceof IDimension) {
                        IDimension dim = (IDimension) d;

                        CTFormula f = (CTFormula) dim.getContent().get(0).getValue();

                        if ("cat".equals(dim.getDimensionType())) {
                            if (attrSeries.has("names")) {
                                final Object names = attrSeries.get("names");
                                if (names != null) {
                                    f.setValue(names.toString());
                                } else {
                                    f.setValue("");
                                }
                            }
                        } else if ("size".equals(dim.getDimensionType())) {
                            if (attrSeries.has("values")) {
                                final Object values = attrSeries.get("values");
                                if (values != null) {
                                    f.setValue(values.toString());
                                } else {
                                    f.setValue("");
                                }
                            }
                        }
                    }
                }

            }
        }
    }

}
