/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.xlsx.components;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.dml.spreadsheetdrawing.CTConnector;
import org.docx4j.dml.spreadsheetdrawing.CTGraphicalObjectFrame;
import org.docx4j.dml.spreadsheetdrawing.CTGroupShape;
import org.docx4j.dml.spreadsheetdrawing.CTPicture;
import org.docx4j.dml.spreadsheetdrawing.CTShape;
import org.docx4j.dml.spreadsheetdrawing.CTTwoCellAnchor;
import org.docx4j.dml.spreadsheetdrawing.ICellAnchor;
import org.docx4j.mce.AlternateContent.Choice;
import org.docx4j.wml.ContentAccessor;
import org.json.JSONException;
import org.json.JSONObject;
import org.xlsx4j.sml.Sheet;
import com.openexchange.office.filter.ooxml.OperationDocument;
import com.openexchange.office.filter.ooxml.components.Component;
import com.openexchange.office.filter.ooxml.components.ComponentContext;
import com.openexchange.office.filter.ooxml.operations.CreateOperationHelper;
import com.openexchange.office.filter.ooxml.xlsx.XlsxOperationDocument;
import com.openexchange.office.filter.ooxml.xlsx.tools.Drawings;

public class SheetComponent extends XlsxComponent {

    public SheetComponent(XlsxOperationDocument operationDocument, ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(operationDocument, parentContext, new IndexedNode<Object>(new SheetWrapper(_node, operationDocument), _componentNumber), _componentNumber);
    }

    public SheetComponent(Sheet sheet, XlsxOperationDocument operationDocument, int _componentNumber) {
        super(operationDocument, null, new IndexedNode<Object>(new SheetWrapper(new IndexedNode<Object>(sheet), operationDocument), _componentNumber), _componentNumber);
    }

    @Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final int index = previousChildContext!=null?previousChildContext.getNode().getIndex()+1:0;
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;

        Component nextComponent = null;
        final IndexedNode<Object> sheetNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)sheetNode.getData()).getContent();
        for(int i=index; nodeList!=null&& nextComponent==null && i<nodeList.size(); i++) {
            final IndexedNode<Object> childNode = nodeList.getNode(i);
            final Object o = getContentModel(childNode, sheetNode.getData());
            if(o instanceof ICellAnchor) {
                final ICellAnchor cellAnchor = (ICellAnchor)o;

                Component alt = null;
                if (cellAnchor.getAlternateContent() != null) {
                    Choice choise = cellAnchor.getAlternateContent().getChoice().get(0);
                    String requires = choise.getRequires();
                    if ("cx1".equals(requires) || "cx2".equals(requires) || "cx4".equals(requires)) {
                        for (Object ch : choise.getAny()) {
                            if (ch instanceof CTGraphicalObjectFrame) {
                                CTGraphicalObjectFrame g = (CTGraphicalObjectFrame) ch;
                                alt = new ShapeGraphicComponent(getOperationDocument(), this, new IndexedNode<Object>(g, childNode.getIndex()), cellAnchor, nextComponentNumber);
                                break;
                            }
                        }
                    }

                }

                if (alt != null) {
                    nextComponent = alt;
                    continue;
                }

                if(cellAnchor.getGrpSp()!=null) {
                    nextComponent = new ShapeGroupComponent(getOperationDocument(), this, new IndexedNode<Object>(cellAnchor.getGrpSp(), childNode.getIndex()), cellAnchor, nextComponentNumber);
                }
                else if(cellAnchor.getSp()!=null) {
                    nextComponent = new ShapeComponent(getOperationDocument(), this, new IndexedNode<Object>(cellAnchor.getSp(), childNode.getIndex()), cellAnchor, nextComponentNumber);
                }
                else if(cellAnchor.getGraphicFrame()!=null) {
                    nextComponent = new ShapeGraphicComponent(getOperationDocument(), this, new IndexedNode<Object>(cellAnchor.getGraphicFrame(), childNode.getIndex()), cellAnchor, nextComponentNumber);
                }
                else if(cellAnchor.getCxnSp()!=null) {
                    nextComponent = new ShapeConnectorComponent(getOperationDocument(), this, new IndexedNode<Object>(cellAnchor.getCxnSp(), childNode.getIndex()), cellAnchor, nextComponentNumber);
                }
                else if(cellAnchor.getPic()!=null) {
                    nextComponent = new ShapePicComponent(getOperationDocument(), this, new IndexedNode<Object>(cellAnchor.getPic(), childNode.getIndex()), cellAnchor, nextComponentNumber);
                }
            }
        }
        return nextComponent;
    }

    @Override
    public Component insertChildComponent(ComponentContext parentContext, IndexedNode<Object> contextNode, int number, Component child, Type type) {

    	IndexedNodeList<Object> indexedNodeList = ((SheetWrapper)contextNode.getData()).getContent(true);
        IndexedNode<Object> referenceNode = child!=null ? child.getNode() : null;

        final CTTwoCellAnchor cellAnchor = new CTTwoCellAnchor();
        switch(type) {
        	case AC_SHAPE: {
	            final CTShape newChild = Drawings.createShape();
	            cellAnchor.setSp(newChild);
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeComponent(getOperationDocument(), parentContext, newChildNode, cellAnchor, number);
        	}
        	case AC_GROUP: {
	            final CTGroupShape newChild = Drawings.createGroupShape();
	            cellAnchor.setGrpSp(newChild);
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeGroupComponent(getOperationDocument(), parentContext, newChildNode, cellAnchor, number);
        	}
        	case AC_CHART: {
                try {
                    final CTGraphicalObjectFrame newChild = Drawings.createChart(getOperationDocument(), getOperationDocument().getContextPart(), new JSONObject());
                    cellAnchor.setGraphicFrame(newChild);
                    newChild.setParent(contextNode.getData());
                    final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
                    indexedNodeList.addNode(referenceNode, newChildNode, true);
                    return new ShapeGraphicComponent(getOperationDocument(), parentContext, newChildNode, cellAnchor, number);
                }
                catch(Exception e) {
                    throw new UnsupportedOperationException();
                }
        	}
            case AC_CONNECTOR: {
                final CTConnector newChild = Drawings.createConnectorShape();
                cellAnchor.setCxnSp(newChild);
                newChild.setParent(contextNode.getData());
                final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
                indexedNodeList.addNode(referenceNode, newChildNode, true);
                return new ShapeConnectorComponent(getOperationDocument(), parentContext, newChildNode, cellAnchor, number);
            }
            case AC_IMAGE: {
                final CTPicture newChild = Drawings.createImage();
                cellAnchor.setPic(newChild);
                newChild.setParent(contextNode.getData());
                final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
                indexedNodeList.addNode(referenceNode, newChildNode, true);
                return new ShapePicComponent(getOperationDocument(), parentContext, newChildNode, cellAnchor, number);
            }
        	default : {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs) {

    }

    @Override
    public JSONObject createJSONAttrs(CreateOperationHelper createOperationHelper, JSONObject attrs)
    	throws JSONException {

		return attrs;
    }
}
