/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.xlsx.components;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.dml.spreadsheetdrawing.CTConnector;
import org.docx4j.dml.spreadsheetdrawing.CTGraphicalObjectFrame;
import org.docx4j.dml.spreadsheetdrawing.CTGroupShape;
import org.docx4j.dml.spreadsheetdrawing.CTPicture;
import org.docx4j.dml.spreadsheetdrawing.CTShape;
import org.docx4j.dml.spreadsheetdrawing.ICellAnchor;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.ContentAccessor;
import org.json.JSONException;
import org.json.JSONObject;
import org.jvnet.jaxb2_commons.ppp.Child;
import com.openexchange.office.filter.ooxml.OperationDocument;
import com.openexchange.office.filter.ooxml.components.Component;
import com.openexchange.office.filter.ooxml.components.ComponentContext;
import com.openexchange.office.filter.ooxml.components.IShapeType;
import com.openexchange.office.filter.ooxml.components.ShapeType;
import com.openexchange.office.filter.ooxml.operations.CreateOperationHelper;
import com.openexchange.office.filter.ooxml.xlsx.XlsxOperationDocument;
import com.openexchange.office.filter.ooxml.xlsx.tools.Drawings;

public class ShapeGroupComponent extends XlsxComponent implements IShapeType {

	final private CTGroupShape groupShape;
	private ICellAnchor cellAnchor;

	public ShapeGroupComponent(XlsxOperationDocument operationDocument, ComponentContext parentContext, IndexedNode<Object> _node, ICellAnchor cellAnchor, int _componentNumber) {
        super(operationDocument, parentContext, _node, _componentNumber);

        groupShape = (CTGroupShape)getObject();
        this.cellAnchor = cellAnchor;
	}

    @Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final int index = previousChildContext!=null?previousChildContext.getNode().getIndex()+1:0;
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;

        Component nextComponent = null;
        final IndexedNode<Object> groupShapeNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)groupShapeNode.getData()).getContent();
        for(int i=index; nextComponent==null&&i<nodeList.size(); i++) {
            final IndexedNode<Object> childNode = nodeList.getNode(i);
            final Object o = getContentModel(childNode, groupShapeNode.getData());
            if(o instanceof CTGroupShape) {
            	nextComponent = new ShapeGroupComponent(getOperationDocument(), this, childNode, null, nextComponentNumber);
            }
            else if(o instanceof CTShape) {
            	nextComponent = new ShapeComponent(getOperationDocument(), this, childNode, null, nextComponentNumber);
            }
            else if(o instanceof CTGraphicalObjectFrame) {
            	nextComponent = new ShapeGraphicComponent(getOperationDocument(), this, childNode, null, nextComponentNumber);
            }
            else if(o instanceof CTConnector) {
            	nextComponent = new ShapeConnectorComponent(getOperationDocument(), this, childNode, null, nextComponentNumber);
            }
            else if(o instanceof CTPicture) {
            	nextComponent = new ShapePicComponent(getOperationDocument(), this, childNode, null, nextComponentNumber);
            }
        }
        return nextComponent;
    }

    @Override
    public Component insertChildComponent(ComponentContext parentContext, IndexedNode<Object> contextNode, int number, Component child, Type type) {

    	IndexedNodeList<Object> indexedNodeList = (IndexedNodeList<Object>)((ContentAccessor)contextNode.getData()).getContent();
        IndexedNode<Object> referenceNode = child!=null ? child.getNode() : null;

        switch(type) {
        	case AC_SHAPE: {
	            final Child newChild = Drawings.createShape();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeComponent(getOperationDocument(), parentContext, newChildNode, null, number);
        	}
        	case AC_GROUP: {
	            final Child newChild = Drawings.createGroupShape();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeGroupComponent(getOperationDocument(), parentContext, newChildNode, null, number);
        	}
        	case AC_CHART: {
        	    try {
        	        final Child newChild = Drawings.createChart(getOperationDocument(), getOperationDocument().getContextPart(), new JSONObject());
                    newChild.setParent(contextNode.getData());
                    final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
                    indexedNodeList.addNode(referenceNode, newChildNode, true);
                    return new ShapeGraphicComponent(getOperationDocument(), parentContext, newChildNode, null, number);
        	    }
        	    catch(Exception e) {
        	        throw new UnsupportedOperationException();
        	    }
        	}
        	case AC_CONNECTOR: {
	            final Child newChild = Drawings.createConnectorShape();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapeConnectorComponent(getOperationDocument(), parentContext, newChildNode, null, number);
        	}
        	case AC_IMAGE: {
	            final Child newChild = Drawings.createImage();
	            newChild.setParent(contextNode.getData());
	            final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
	            indexedNodeList.addNode(referenceNode, newChildNode, true);
	            return new ShapePicComponent(getOperationDocument(), parentContext, newChildNode, null, number);
        	}
        	default : {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs) throws JSONException, InvalidFormatException, PartUnrecognisedException {
        if(cellAnchor!=null) {
            final JSONObject drawingAttrs = attrs.optJSONObject("drawing");
            if(drawingAttrs!=null) {
                cellAnchor = Drawings.setDrawingAnchor(drawingAttrs, cellAnchor);
                (((ContentAccessor)getParentComponent().getObject()).getContent()).set(getNode().getIndex(), cellAnchor);
            }
        }
        com.openexchange.office.filter.ooxml.drawingml.GroupShape.applyAttrsFromJSON(operationDocument, attrs, groupShape, cellAnchor!=null);
    }

    @Override
    public JSONObject createJSONAttrs(CreateOperationHelper createOperationHelper, JSONObject attrs)
        throws JSONException {

        final XlsxOperationDocument operationDocument = (XlsxOperationDocument)createOperationHelper.getOperationDocument();
        if(cellAnchor!=null) {
            Drawings.createAnchorOperations(cellAnchor, attrs);
        }
        com.openexchange.office.filter.ooxml.drawingml.GroupShape.createJSONAttrs(operationDocument, attrs, groupShape, cellAnchor!=null);
        return attrs;
    }

	@Override
	public ShapeType getType() {
		return ShapeType.GROUP;
	}
}
