package com.openexchange.office.filter.ooxml.xlsx.components;
/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */



import javax.xml.bind.JAXBException;
import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextLineBreak;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.dml.ITextCharacterProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.ContentAccessor;
import org.json.JSONException;
import org.json.JSONObject;
import org.xlsx4j.sml.CTTextField;
import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.ooxml.OperationDocument;
import com.openexchange.office.filter.ooxml.components.Component;
import com.openexchange.office.filter.ooxml.components.ComponentContext;
import com.openexchange.office.filter.ooxml.components.IParagraph;
import com.openexchange.office.filter.ooxml.drawingml.DMLHelper;
import com.openexchange.office.filter.ooxml.operations.CreateOperationHelper;
import com.openexchange.office.filter.ooxml.xlsx.XlsxOperationDocument;

public class ParagraphComponent extends XlsxComponent implements IParagraph {

    final CTTextParagraph paragraph;

    public ParagraphComponent(XlsxOperationDocument operationDocument, ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(operationDocument, parentContext, _node, _componentNumber);

        paragraph = (CTTextParagraph)getObject();
    }

    @Override
    public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final int index = previousChildContext!=null?previousChildContext.getNode().getIndex()+1:0;
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;

        Component nextComponent = null;
        final IndexedNode<Object> paragraphNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)paragraphNode.getData()).getContent();
        for(int i=index; nextComponent==null&&i<nodeList.size(); i++) {
            final IndexedNode<Object> childNode = nodeList.getNode(i);
            final Object o = getContentModel(childNode, paragraphNode.getData());
            if(o instanceof CTRegularTextRun) {
                if(((CTRegularTextRun)o).getT()!=null&&!((CTRegularTextRun)o).getT().isEmpty()) {
                    nextComponent = new TextComponent(getOperationDocument(), this, childNode, nextComponentNumber);
                }
            }
            else if(o instanceof CTTextField) {
                nextComponent = new TextFieldComponent(getOperationDocument(), this, childNode, nextComponentNumber);
            }
            else if(o instanceof CTTextLineBreak) {
                nextComponent = new HardBreakComponent(getOperationDocument(), this, childNode, nextComponentNumber);
            }
       }
        return nextComponent;
    }

    @Override
    public void insertText(OperationDocument operationDocument, int textPosition, String text, JSONObject attrs)
            throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

        if(text.length()>0) {
            Component childComponent = getNextChildComponent(null, null);
            Component cRet = null;

            if(childComponent!=null) {
                if(textPosition>0) {
                    childComponent = childComponent.getComponent(textPosition-1);
                }
                // check if the character could be inserted into an existing text:
                if(childComponent instanceof TextComponent) {
                    final CTRegularTextRun t = (CTRegularTextRun)childComponent.getObject();
                    final StringBuffer s = new StringBuffer(t.getT());
                    s.insert(textPosition-((TextComponent)childComponent).getComponentNumber(), text);
                    t.setT(s.toString());
                    cRet = childComponent;
                }
                else {
                    final CTRegularTextRun newRun = Context.getDmlObjectFactory().createCTRegularTextRun();
                    newRun.setParent(getObject());
                    newRun.setT(text);
                    (paragraph.getContent()).addNode(childComponent.getNode(), new IndexedNode<Object>(newRun), textPosition == 0 ? true : false);

                    CTTextCharacterProperties referenceRPr = null;
                    if(childComponent.getObject() instanceof ITextCharacterProperties) {
                        referenceRPr = ((ITextCharacterProperties)childComponent.getObject()).getRPr(false);
                    }
                    if(referenceRPr!=null) {
                        final CTTextCharacterProperties newRPr = XmlUtils.deepCopy(referenceRPr);
                        if(newRPr!=null) {
                            newRun.setRPr(newRPr);
                        }
                    }
                    if(textPosition==0) {
                        cRet = getNextChildComponent(null, null);
                    }
                    else {
                        cRet = childComponent.getNextComponent();
                    }
                }
          }
          else {
              // the paragraph is empty, we have to create R and its text
              final CTRegularTextRun newRun = Context.getDmlObjectFactory().createCTRegularTextRun();
              newRun.setParent(getObject());
              paragraph.getContent().add(newRun);
              if(paragraph.getEndParaRPr(false)!=null) {
                  newRun.setRPr(XmlUtils.deepCopy(paragraph.getEndParaRPr(true)));
              }
              else if(paragraph.getPPr(false)!=null&&paragraph.getPPr(false).getDefRPr(false)!=null) {
                  newRun.setRPr(XmlUtils.deepCopy(paragraph.getPPr(false).getDefRPr(true)));
              }
              newRun.setT(text);
              cRet = getNextChildComponent(null, null);
            }
            ((CTRegularTextRun)cRet.getObject()).getRPr(true).setDirty(Boolean.valueOf(false));
            if(attrs!=null) {
                cRet.splitStart(textPosition, SplitMode.ATTRIBUTE);
                cRet.splitEnd(textPosition+text.length()-1, SplitMode.ATTRIBUTE);
                cRet.applyAttrsFromJSON(operationDocument, attrs);
            }
        }
    }

    @Override
    public void splitParagraph(int textPosition) {
        // creating and inserting our new paragraph
        final CTTextParagraph destParagraph = Context.getDmlObjectFactory().createCTTextParagraph();
        destParagraph.setParent(paragraph.getParent());
        final IndexedNode<Object> destParagraphNode = new IndexedNode<Object>(destParagraph);
        ((IndexedNodeList<Object>)((ContentAccessor)paragraph.getParent()).getContent()).addNode(getNode(), destParagraphNode, textPosition==0);

        CTTextCharacterProperties lastRPr = null;
        if(textPosition>0) {
            // splitting the paragraph
            Component childComponent = getChildComponent(textPosition-1);
            if(childComponent!=null) {
                lastRPr = ((ITextCharacterProperties)childComponent.getObject()).getRPr(false);
                childComponent.splitEnd(textPosition-1, SplitMode.DELETE);

                // moving text runs into the new paragraph
                int sourceIndex = childComponent.getNode().getIndex() + 1;
                final int size = paragraph.getContent().size() - sourceIndex;
                if(size>0) {
                    IndexedNodeList.moveNodes(paragraph.getContent(), destParagraph.getContent(), sourceIndex,
                        0, size, destParagraph);
                }
            }
        }

        final CTTextParagraphProperties sourceParagraphProperties = paragraph.getPPr(false);
        if(sourceParagraphProperties!=null){
            final CTTextParagraphProperties destParagraphProperties = XmlUtils.deepCopy(sourceParagraphProperties);
            destParagraph.setPPr(destParagraphProperties);
        }

        // taking care of paragraph attributes
        if(lastRPr!=null) {
            // if available, we have to get the character attributes from the last textrun
            destParagraph.getPPr(true).setDefRPr(XmlUtils.deepCopy(lastRPr));
        }
    }

    @Override
    public void mergeParagraph() {
        final Component nextParagraphComponent = getNextComponent();
        if(nextParagraphComponent instanceof ParagraphComponent) {
            final IndexedNodeList<Object> sourceContent = ((CTTextParagraph)nextParagraphComponent.getObject()).getContent();
            final IndexedNodeList<Object> destContent = paragraph.getContent();
            if(sourceContent.size()>0) {
                IndexedNodeList.moveNodes(sourceContent, destContent, 0, destContent.size(), sourceContent.size(), paragraph);
            }
            IndexedNode<Object> parentContextNode = nextParagraphComponent.getParentContext().getNode();
            ((ContentAccessor)parentContextNode.getData()).getContent().remove(nextParagraphComponent.getObject());
        }
    }

    @Override
    public void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs)
        throws JSONException, InvalidFormatException, PartUnrecognisedException {

        DMLHelper.applyTextParagraphPropertiesFromJson(paragraph.getPPr(true), attrs, operationDocument);
    }

    @Override
    public JSONObject createJSONAttrs(CreateOperationHelper createOperationHelper, JSONObject attrs)
            throws JSONException, FilterException {

        DMLHelper.createJsonFromTextParagraphProperties(attrs, paragraph.getPPr(false), createOperationHelper.getOperationDocument().getContextPart());
        if(paragraph.getEndParaRPr(false)!=null&&paragraph.getContent().isEmpty()) {
            DMLHelper.createJsonFromTextCharacterProperties(attrs, paragraph.getEndParaRPr(false), createOperationHelper.getOperationDocument().getContextPart());
        }
        return attrs;
    }

    public void checkSetLevel(JSONObject attrs) {
        if(attrs!=null) {
            final JSONObject paragraphAttrs = attrs.optJSONObject("paragraph");
            if(paragraphAttrs!=null) {
                final Object l = paragraphAttrs.opt("level");
                if(l!=null) {
                    paragraph.getPPr(true).setLvl(l instanceof Number ? ((Number)l).intValue() : 0);
                }
            }
        }
    }

    public int getLevel() {
        final CTTextParagraphProperties properties = paragraph.getPPr(false);
        final Integer lvl = properties!=null ? properties.getLvl() : null;
        return lvl!=null ? lvl.intValue() : 0;
    }

    @Override
    public Component insertChildComponent(com.openexchange.office.filter.ooxml.OperationDocument operationDocument, int textPosition, JSONObject attrs, Type childType)
        throws JSONException, JAXBException, InvalidFormatException, PartUnrecognisedException {

        Object newChild = null;

        CTTextCharacterProperties textCharacterProperties = null;
        if(childType == Type.HARDBREAK_DEFAULT) {
            newChild = Context.getDmlObjectFactory().createCTTextLineBreak();
        }
        else if(childType == Type.SIMPLE_FIELD) {
            newChild = Context.getDmlObjectFactory().createCTTextField();
        }
        Component childComponent = getNextChildComponent(null, null);
        if(childComponent!=null) {
            if(textPosition>0) {
                childComponent = childComponent.getComponent(textPosition-1);
                childComponent.splitEnd(textPosition-1, SplitMode.ATTRIBUTE);
            }
            if(childComponent.getObject() instanceof ITextCharacterProperties) {
                textCharacterProperties = ((ITextCharacterProperties)childComponent.getObject()).getRPr(false);
            }
            final ContentAccessor parentContextObject = (ContentAccessor)childComponent.getParentContext().getNode().getData();
            ((IndexedNodeList<Object>)parentContextObject.getContent()).addNode(childComponent.getNode(), new IndexedNode<Object>(newChild), textPosition==0);
        }
        else {
            paragraph.getContent().addNode(new IndexedNode<Object>(newChild));
            textCharacterProperties = paragraph.getEndParaRPr(false);
        }
        if(textPosition>0) {
            childComponent = childComponent.getNextComponent();
        }
        else {
            childComponent = getNextChildComponent(null, null);
        }
        if(textCharacterProperties!=null&&childComponent.getObject() instanceof ITextCharacterProperties) {
            ((ITextCharacterProperties)childComponent.getObject()).setRPr(XmlUtils.deepCopy(textCharacterProperties));
        }
        if(attrs!=null) {
            childComponent.applyAttrsFromJSON(operationDocument, attrs);
        }
        return childComponent;
    }
}
