/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.tools;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.CTMarkup;
import org.docx4j.wml.CTRPrChange;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.DelText;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RPrBase;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.RunDel;
import org.docx4j.wml.RunIns;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.Text;
import org.docx4j.wml.TrPr;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.ooxml.docx.DocxOperationDocument;
import com.openexchange.office.filter.ooxml.docx.components.TextRun_Base;
import com.openexchange.office.filter.ooxml.tools.Commons;

public class TextUtils{

    public static void copyRPrBase(RPrBase rDest, RPrBase rSource) {
        rDest.setB(rSource.getB());
        rDest.setBCs(rSource.getBCs());
        rDest.setBdr(rSource.getBdr());
        rDest.setCaps(rSource.getCaps());
        rDest.setColor(rSource.getColor());
        rDest.setCs(rSource.getCs());
        rDest.setDstrike(rSource.getDstrike());
        rDest.setEastAsianLayout(rSource.getEastAsianLayout());
        rDest.setEffect(rSource.getEffect());
        rDest.setEm(rSource.getEm());
        rDest.setEmboss(rSource.getEmboss());
        rDest.setFitText(rSource.getFitText());
        rDest.setHighlight(rSource.getHighlight());
        rDest.setI(rSource.getI());
        rDest.setICs(rSource.getICs());
        rDest.setImprint(rSource.getImprint());
        rDest.setKern(rSource.getKern());
        rDest.setLang(rSource.getLang(false));
        rDest.setNoProof(rSource.getNoProof());
        rDest.setOMath(rSource.getOMath());
        rDest.setOutline(rSource.getOutline());
        rDest.setPosition(rSource.getPosition());
        rDest.setRFonts(rSource.getRFonts());
        rDest.setRStyle(rSource.getRStyle());
        rDest.setRtl(rSource.getRtl());
        rDest.setShadow(rSource.getShadow());
        rDest.setShd(rSource.getShd());
        rDest.setSmallCaps(rSource.getSmallCaps());
        rDest.setSnapToGrid(rSource.getSnapToGrid());
        rDest.setSpacing(rSource.getSpacing());
        rDest.setSpecVanish(rSource.getSpecVanish());
        rDest.setStrike(rSource.getStrike());
        rDest.setSz(rSource.getSz());
        rDest.setSzCs(rSource.getSzCs());
        rDest.setU(rSource.getU());
        rDest.setVanish(rSource.getVanish());
        rDest.setVertAlign(rSource.getVertAlign());
        rDest.setW(rSource.getW());
        rDest.setWebHidden(rSource.getWebHidden());
    }

    public static RPr cloneParaRPrToRPr(ParaRPr _paraRPr) {
        RPr rPr = null;
        if(_paraRPr!=null) {
            final ParaRPr destParaProperties = XmlUtils.deepCopy(_paraRPr);
            if(destParaProperties!=null) {
                rPr = Context.getWmlObjectFactory().createRPr();
                copyRPrBase(rPr, destParaProperties);
            }
        }
        return rPr;
    }

    public static ParaRPr cloneRPrToParaRPr(RPr _rPr) {
        ParaRPr rPr = null;
        if(_rPr!=null) {
            final RPr destParaProperties = XmlUtils.deepCopy(_rPr);
            if(destParaProperties!=null) {
                rPr = Context.getWmlObjectFactory().createParaRPr();
                copyRPrBase(rPr, destParaProperties);
            }
        }
        return rPr;
    }

    // resetting id which has to be unique
    public static void resetMarkupId(CTMarkup trackChange) {
    	if(trackChange!=null) {
    		trackChange.setId(null);
    	}
    }

    // resetting id which has to be unique
    public static void resetMarkupId(RPr rPr) {
    	if(rPr!=null) {
    		resetMarkupId(rPr.getRPrChange());
    	}
    }

	// resetting id which has to be unique
    public static void resetMarkupId(PPr pPr) {
    	if(pPr!=null) {
    		resetMarkupId(pPr.getPPrChange());
	        final ParaRPr rPr = pPr.getRPr();
	        if(rPr!=null) {
	        	resetMarkupId(rPr.getRPrChange());
	        	resetMarkupId(rPr.getDel());
	        	resetMarkupId(rPr.getIns());
	        	resetMarkupId(rPr.getMoveFrom());
	        	resetMarkupId(rPr.getMoveTo());
	        }
    	}
    }

	// resetting id which has to be unique
    public static void resetMarkupId(TrPr trPr) {
    	if(trPr!=null) {
    		resetMarkupId(trPr.getDel());
    		resetMarkupId(trPr.getIns());
    		resetMarkupId(trPr.getTrPrChange());
    	}
    }

	// resetting id which has to be unique
    public static void resetMarkupId(TcPr tcPr) {
    	if(tcPr!=null) {
    		resetMarkupId(tcPr.getCellDel());
    		resetMarkupId(tcPr.getCellIns());
    		resetMarkupId(tcPr.getCellMerge());
    		resetMarkupId(tcPr.getTcPrChange());
    	}
    }

	// resetting id which has to be unique (without tbl content)
    public static void resetMarkupId(Tbl tbl) {
    	if(tbl!=null) {
    		final TblGrid tblGrid = tbl.getTblGrid();
    		if(tblGrid!=null) {
    			resetMarkupId(tblGrid.getTblGridChange());
    		}
    		final TblPr tblPr = tbl.getTblPr();
    		if(tblPr!=null) {
    			resetMarkupId(tblPr.getTblPrChange());
    		}
    	}
    }

    private static void delTextToText(int index, Object o) {
    	if(o instanceof ContentAccessor) {
    		final List<Object> content = ((ContentAccessor)o).getContent();
    		for(int i=0; i<content.size(); i++) {
    			delTextToText(i, content.get(i));
    		}
    	}
    	else if(o instanceof DelText) {
			final Text text = Context.getWmlObjectFactory().createText();
			Object parent = ((DelText)o).getParent();
			text.setParent(parent);
			text.setSpace(((DelText)o).getSpace());
			text.setValue(((DelText)o).getValue());
			((ContentAccessor)parent).getContent().set(index, text);
    	}
    }

    public static JSONObject forceRemoveChangeTrack(JSONObject attrs)
    	throws JSONException {

    	if(attrs==null) {
    		attrs = new JSONObject(1);
    	}
		JSONObject changes = attrs.optJSONObject("changes");
		if(changes == null) {
			changes = new JSONObject(3);
  			changes.put("inserted", JSONObject.NULL);
    		changes.put("removed", JSONObject.NULL);
    		changes.put("modified", JSONObject.NULL);
			attrs.put("changes", changes);
		}
		else {
			if(!changes.has("inserted")) {
				changes.put("inserted", JSONObject.NULL);
			}
			if(!changes.has("removed")) {
        		changes.put("removed", JSONObject.NULL);
			}
			if(!changes.has("modified")) {
				changes.put("modified", JSONObject.NULL);
			}
		}
    	return attrs;
    }

    public static void setTextRunAttributes(DocxOperationDocument operationDocument, JSONObject attrs, TextRun_Base textRunComponent)
        throws FilterException, JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

        int changeTrackFlags = TextRun_Base.CT_NONE;
        Object attrsInserted = null;
        Object attrsRemoved  = null;
        Object attrsModified = null;
        if(attrs!=null) {
        	final Object changes = attrs.opt("changes");
        	if(changes!=null) {
        		if(changes instanceof JSONObject) {
		        	attrsInserted = ((JSONObject)changes).opt("inserted");
		        	if(attrsInserted!=null) {
		        		if(attrsInserted instanceof JSONObject) {
		        			changeTrackFlags |= TextRun_Base.CT_INSERTED<<16|TextRun_Base.CT_INSERTED;
		        		}
		        		else {
		        			changeTrackFlags |= TextRun_Base.CT_INSERTED;
		        		}
		        	}
		        	attrsRemoved = ((JSONObject)changes).opt("removed");
		        	if(attrsRemoved!=null) {
		        		if(attrsRemoved instanceof JSONObject) {
		        			changeTrackFlags |= TextRun_Base.CT_DELETED<<16|TextRun_Base.CT_DELETED;
		        		}
		        		else {
		        			changeTrackFlags |= TextRun_Base.CT_DELETED;
		        		}
		        	}
		        	attrsModified = ((JSONObject)changes).opt("modified");
		        	if(attrsModified!=null) {
		        		if(attrsModified instanceof JSONObject) {
		        			changeTrackFlags |= TextRun_Base.CT_MODIFIED<<16|TextRun_Base.CT_MODIFIED;
		        		}
		        		else {
		        			changeTrackFlags |= TextRun_Base.CT_MODIFIED;
		        		}
		        	}
        		}
        		else {
        			changeTrackFlags = TextRun_Base.CT_MODIFIED | TextRun_Base.CT_DELETED | TextRun_Base.CT_INSERTED;
        		}
        	}
        }
        final IndexedNode<Object> textRunNode = textRunComponent.getTextRunNode();
        final R textRun = (R)textRunNode.getData();
        RPr rPr = textRun.getRPr();
        if (rPr==null) {
            rPr = Context.getWmlObjectFactory().createRPr();
            rPr.setParent(textRun);
            textRun.setRPr(rPr);
        }
        if(attrs!=null) {
            Object styleId = attrs.opt("styleId");
            if(styleId!=null) {
                if (styleId instanceof String) {
                    RStyle rStyle = rPr.getRStyle();
                    if(rStyle==null) {
                        rStyle = Context.getWmlObjectFactory().createRStyle();
                        rStyle.setParent(rPr);
                    }
                    rStyle.setVal((String)styleId);
                    rPr.setRStyle(rStyle);
                }
                else {
                    rPr.setRStyle(null);
                }
            }
            final JSONObject characterAttributes = attrs.optJSONObject("character");
            if((changeTrackFlags&TextRun_Base.CT_MODIFIED)!=0) {
            	if((changeTrackFlags&(TextRun_Base.CT_MODIFIED<<16))!=0) {
            		CTRPrChange rPrChange = rPr.getRPrChange();
            		if(rPrChange==null) {
	                	rPrChange = Context.getWmlObjectFactory().createCTRPrChange();
	                	rPrChange.setParent(rPr);
	                	rPr.setRPrChange(rPrChange);
            		}
            		org.docx4j.wml.CTRPrChange.RPr rPrC = rPrChange.getRPr();
            		if(rPrC==null) {
            			rPrC = Context.getWmlObjectFactory().createCTRPrChangeRPr();
            			rPrC.setParent(rPrChange);
            			rPrChange.setRPr(rPrC);
            		}
					Utils.applyTrackInfoFromJSON(operationDocument, (JSONObject)attrsModified, rPrChange);
            		final Object changedAttrs = ((JSONObject)attrsModified).opt("attrs");
            		if(changedAttrs!=null) {
            			if(changedAttrs instanceof JSONObject) {
            				final Object changedCharacterAttrs = ((JSONObject)changedAttrs).opt("character");
            				if(changedCharacterAttrs!=null) {
            					if(changedCharacterAttrs instanceof JSONObject) {
            						Character.applyCharacterProperties(operationDocument, ((JSONObject)changedAttrs).optJSONObject("character"), rPrC);
            					}
            					else {
            						rPrChange.setRPr(null);
            					}
            				}
            			}
            			else {
            				rPrChange.setRPr(null);
            			}
            		}
            	}
            	else {
            		rPr.setRPrChange(null);
            	}
            }
            if(characterAttributes!=null) {
                Character.applyCharacterProperties(operationDocument, characterAttributes, rPr);

                final Object url = characterAttributes.opt("url");
                final Object anchor = characterAttributes.opt("anchor");
                if(url!=null||anchor!=null) {
                    final IndexedNode<Object> hyperlinkNode = textRunComponent.getHyperlinkNode(true);
                    final P.Hyperlink hyperlink = (P.Hyperlink)hyperlinkNode.getData();
                	if(url instanceof String) {
                        hyperlink.setId(Commons.setUrl(operationDocument.getContextPart(), hyperlink.getId(), (String)url));
	                }
	                else if(url==JSONObject.NULL) {
	                    hyperlink.setId(null);
	                }
                	if(anchor instanceof String) {
                	    hyperlink.setAnchor((String)anchor);
                	}
                	else if(anchor==JSONObject.NULL) {
                	    hyperlink.setAnchor(null);
                	}
                	if(hyperlink.isEmpty()) {
                        textRunComponent.removeHyperlink();
                	}
                }
            }
        }

    	if((changeTrackFlags&TextRun_Base.CT_DELETED)!=0) {
    		IndexedNode<Object> delNode = textRunComponent.getRunDelNode(false);
    		if((changeTrackFlags&(TextRun_Base.CT_DELETED<<16))!=0) {
    			// delNode is needed
    			if(delNode==null) {
    				delNode = textRunComponent.getRunDelNode(true);

        			// changing text to delText
        			final IndexedNodeList<Object> textRunContent = textRun.getContent();
        			for(int i = 0; i<textRunContent.size(); i++) {
        				final Object o = textRunContent.get(i);
        				if(o instanceof Text) {
        					final Text text = (Text)o;
        					final DelText delText = Context.getWmlObjectFactory().createDelText();
        					delText.setParent(text.getParent());
        					delText.setSpace(text.getSpace());
        					delText.setValue(text.getValue());
        					textRunContent.set(i, delText);
        				}
        			}
    			}
    			Utils.applyTrackInfoFromJSON(operationDocument, (JSONObject)attrsRemoved, (RunDel)delNode.getData());
    		}
    		else if (delNode!=null) {
    			// delNode is to be removed
    		    delTextToText(0, delNode.getData());
    			textRunComponent.removeRunDelNode();
    		}
    	}

    	if((changeTrackFlags&TextRun_Base.CT_INSERTED)!=0) {
    		if((changeTrackFlags&(TextRun_Base.CT_INSERTED<<16))!=0) {
    			// insertNode is needed
    			final IndexedNode<Object> insertNode = textRunComponent.getRunInsNode(true);
    			Utils.applyTrackInfoFromJSON(operationDocument, (JSONObject)attrsInserted, (RunIns)insertNode.getData());
    		}
    		else {
    			// insertNode is to be removed
				textRunComponent.removeRunInsNode();
    		}
    	}
    }
}
