/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.components;

import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.docx4j.IndexedNode;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTFFCheckBox;
import org.docx4j.wml.CTFFDDList;
import org.docx4j.wml.CTFFData;
import org.docx4j.wml.CTFFTextInput;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.STFldCharType;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.ooxml.OperationDocument;
import com.openexchange.office.filter.ooxml.components.ComponentContext;
import com.openexchange.office.filter.ooxml.operations.CreateOperationHelper;

abstract class FldChar_Base extends TextRun_Base {

    final FldChar fldChar;

    public FldChar_Base(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);

        fldChar = (FldChar)getObject();
    }

    @Override
	public void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs)
			throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

		if(fldChar.getFldCharType()==STFldCharType.SEPARATE) {
			final Object characterAttrs = attrs.opt("character");
			if(characterAttrs instanceof JSONObject) {
				final Object autoDateField = ((JSONObject)characterAttrs).opt("autoDateField");
				if(autoDateField instanceof Boolean) {
					applyAutoDateField((Boolean)autoDateField);
				}
				else {
					applyAutoDateField(true);
				}
			}
		}
		else if(fldChar.getFldCharType()==STFldCharType.BEGIN) {
		    final JSONObject characterAttrs = attrs.optJSONObject("character");
		    if(characterAttrs!=null) {
		        final JSONObject fieldAttrs = characterAttrs.optJSONObject("field");
		        if(fieldAttrs!=null) {
		            final Object formFieldType = fieldAttrs.opt("formFieldType");
		            if(formFieldType!=null) {
		                if(formFieldType instanceof String) {
		                    if(formFieldType.equals("checkBox")) {
		                        final CTFFData ctFFData = new CTFFData();
		                        fldChar.setFfData(ctFFData);
		                        final CTFFCheckBox checkBox = new CTFFCheckBox();
		                        final Object checked = fieldAttrs.opt("checked");
		                        if(checked instanceof Boolean) {
		                            checkBox.setChecked(new BooleanDefaultTrue((Boolean)checked));
		                        }
		                        ctFFData.getNameOrEnabledOrCalcOnExit().add(Context.getWmlObjectFactory().createCTFFDataCheckBox(checkBox));
		                    }
		                    else if(formFieldType.equals("textInput")) {
                                final CTFFData ctFFData = new CTFFData();
                                fldChar.setFfData(ctFFData);
                                final CTFFTextInput textInput = new CTFFTextInput();
                                ctFFData.getNameOrEnabledOrCalcOnExit().add(Context.getWmlObjectFactory().createCTFFDataTextInput(textInput));
		                    }
		                    else if(formFieldType.equals("dropDownList")) {
                                final CTFFData ctFFData = new CTFFData();
                                fldChar.setFfData(ctFFData);
                                final CTFFDDList ddList = new CTFFDDList();
                                ctFFData.getNameOrEnabledOrCalcOnExit().add(Context.getWmlObjectFactory().createCTFFDataDdList(ddList));
		                    }
		                }
		                else {
		                    fldChar.setFfData(null);
		                }
		            }
		        }
		    }
		}
		super.applyAttrsFromJSON(operationDocument, attrs);
	}

	@Override
	public JSONObject createJSONAttrs(CreateOperationHelper createOperationHelper, JSONObject attrs)
			throws JSONException, ParseException, FilterException {

		super.createJSONAttrs(createOperationHelper, attrs);

		if(fldChar.getFldCharType()==STFldCharType.SEPARATE&&getComponentNumber()-1>=0) {
			final Object prev = getParentComponent().getChildComponent(getComponentNumber()-1).getObject();
			if(prev instanceof FldChar) {
				JSONObject characterAttrs = attrs.optJSONObject("character");
				if(characterAttrs==null) {
					characterAttrs = new JSONObject(1);
					attrs.put("character", characterAttrs);
				}
				characterAttrs.put("autoDateField", !((FldChar)prev).isFldLock());
			}
		}
		final CTFFData ffData = fldChar.getFfData();
		if(ffData!=null) {
		    JSONObject characterAttrs = attrs.optJSONObject("character");
		    if(characterAttrs==null) {
		        characterAttrs = new JSONObject(1);
		        attrs.put("character", characterAttrs);
		    }
		    final JSONObject field = new JSONObject();
		    final List<JAXBElement<?>> ffContent = ffData.getNameOrEnabledOrCalcOnExit();
		    final Iterator<JAXBElement<?>> ffIter = ffContent.iterator();
		    boolean enabled = true;
		    while(ffIter.hasNext()) {
		        final JAXBElement<?> ffEntry = ffIter.next();
		        final Object ffEntryValue = ffEntry.getValue();
		        if(ffEntryValue instanceof CTFFCheckBox) {
		            field.put("formFieldType", "checkBox");
		            final BooleanDefaultTrue defaultV = ((CTFFCheckBox)ffEntryValue).getDefault();
		            final BooleanDefaultTrue checkedV = ((CTFFCheckBox)ffEntryValue).getChecked();
		            boolean checked = true;
		            if(checkedV!=null) {
		                checked = checkedV.isVal();
		            }
		            else if(defaultV!=null) {
		                checked = defaultV.isVal();
		            }
                    field.put("checked", checked);
		        }
		        else if(ffEntryValue instanceof CTFFTextInput) {
		            field.put("formFieldType", "textInput");
		        }
		        else if(ffEntryValue instanceof CTFFDDList) {
		            field.put("formFieldtype", "dropDownList");
		        }
		        else if(ffEntryValue instanceof BooleanDefaultTrue) {
		            if(ffEntry.getName().getLocalPart().equals("enabled")) {
		                enabled = ((BooleanDefaultTrue)ffEntryValue).isVal();
		            }
		        }
		    }
		    field.put("enabled", enabled);
		    characterAttrs.put("field", field);
		}
		return attrs;
	}

    private void applyAutoDateField(Boolean val) {
    	if(getComponentNumber()-1>=0) {
    		final Object prev = getParentComponent().getChildComponent(getComponentNumber()-1).getObject();
    		if(prev instanceof FldChar) {
    			if(((FldChar)prev).getFldCharType() == STFldCharType.BEGIN) {
    				((FldChar)prev).setFldLock(val!=null?!val.booleanValue():false);
    			}
    		}
    	}
    }
}
