/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odt.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.DLList;
import com.openexchange.office.filter.odf.INodeAccessor;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class Paragraph implements IElementWriter, INodeAccessor {

	private DLList<Object> content;
	private final boolean header;
	private TextListItem textListItem;

	// attributes
	private final String id;
	private final String classNames;
	private String styleName;
	private final String conditionalStyleName;
	private final String xHtmlAbout;
	private final String xHtmlContent;
	private final String xHtmlDataType;
	private final String xHtmlProperty;
	private final String xmlId;
	// attributes if header
	private final String isListHeader;
	private Integer outlineLevel;
	private final String restartNumbering;
	private Integer startValue;

	private int listLevel;

	private char lastChar;

	public Paragraph(TextListItem textListItem) {
		header = false;
		this.textListItem = textListItem;
		// attributes
		id = null;
		classNames = null;
		styleName = null;
		conditionalStyleName = null;
		xHtmlAbout = null;
		xHtmlContent = null;
		xHtmlDataType = null;
		xHtmlProperty = null;
		xmlId = null;
		// attributes if header
		isListHeader = null;
		outlineLevel = null;
		restartNumbering = null;
		startValue = null;

		listLevel = textListItem!=null ? textListItem.getListLevel() : -1;

		/* lastChar is used only for loading purposes (whitespace handling) */
		lastChar = ' ';
	}

	public Paragraph(boolean header, Attributes attributes, TextListItem textListItem) {

		this.header = header;
		this.textListItem = textListItem;

		// attributes
		id = attributes.getValue("text:id");
		classNames = attributes.getValue("text:class-names");
		styleName = attributes.getValue("text:style-name");
		conditionalStyleName = attributes.getValue("text:cond-style-name");
		xHtmlAbout = attributes.getValue("xhtml:about");
		xHtmlContent = attributes.getValue("xhtml:content");
		xHtmlDataType = attributes.getValue("xhtml:datatype");
		xHtmlProperty = attributes.getValue("xhtml:property");
		xmlId = attributes.getValue("xml:id");

		// attributes if header:
		if(header) {
			isListHeader = attributes.getValue("text:is-list-header");
			restartNumbering = attributes.getValue("text:restart-numbering");
			String s = attributes.getValue("text:start-value");
			if(s!=null&&!s.isEmpty()) {
				startValue = Integer.parseInt(s);
			}
			s = attributes.getValue("text:outline-level");
			if(s!=null&&!s.isEmpty()) {
				outlineLevel = Integer.parseInt(s);
			}
		}
		else {
			isListHeader = null;
			outlineLevel = null;
			restartNumbering = null;
			startValue = null;
		}
		listLevel = textListItem!=null ? textListItem.getListLevel() : -1;
		lastChar = ' ';
	}

	public void setListLevel(int level) {
		listLevel = level;
		if(level==-1) {
			textListItem = null;
		}
		else if(textListItem!=null) {
			final int currentLevel = textListItem.getListLevel();
			final boolean isHeader = textListItem.isHeader();
			int d = level - currentLevel;
			while(d>0) {
				final TextList textList = new TextList(textListItem);
				textListItem = new TextListItem(textList);
				textListItem.setIsHeader(isHeader);
				d--;
			}
			while(d<0) {
				textListItem = textListItem.getParentTextList().getParentTextListItem();
				d++;
			}
			textListItem.getParentTextList().setContinueNumbering(true);
		}
	}

	public int getListLevel() {
		return listLevel;
	}

	public TextListItem getTextListItem() {
		return textListItem;
	}

	public void setTextListItem(TextListItem textListItem) {
		this.textListItem = textListItem;
	}

	@Override
	public DLList<Object> getContent() {
        if (content == null) {
            content = new DLList<Object>();
        }
		return content;
	}

	public String getStyleName() {
		return styleName;
	}

	public void setStyleName(String styleName) {
		this.styleName = styleName;
	}

	public Integer getStartValue() {
		return startValue;
	}

	public void setStartValue(Integer startValue) {
		this.startValue = startValue;
	}

	public Integer getOutlineLevel() {
		return outlineLevel;
	}

	public void setOutlineLevel(Integer outlineLevel) {
		this.outlineLevel = outlineLevel;
	}

	public boolean isHeader() {
		return header;
	}

	public char getLastChar() {
	    return lastChar;
	}

	public void setLastChar(char c) {
	    lastChar = c;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		final String localName = header ? "h" : "p";
		final String qName = "text:" + localName;

		SaxContextHandler.startElement(output, Namespaces.TEXT, localName, qName);

		// writing attributes
		SaxContextHandler.addAttribute(output, Namespaces.TEXT, "id", "text:id", id);
		SaxContextHandler.addAttribute(output, Namespaces.TEXT, "class-names", "text:class-names", classNames);
		SaxContextHandler.addAttribute(output, Namespaces.TEXT, "style-name", "text:style-name", styleName);
		SaxContextHandler.addAttribute(output, Namespaces.TEXT, "cond-style-name", "text:cond-style-name", conditionalStyleName);
		SaxContextHandler.addAttribute(output, Namespaces.XHTML, "about", "xhtml:about", xHtmlAbout);
		SaxContextHandler.addAttribute(output, Namespaces.XHTML, "content", "xhtml:content", xHtmlContent);
		SaxContextHandler.addAttribute(output, Namespaces.XHTML, "datatype", "xhtml:datatype", xHtmlDataType);
		SaxContextHandler.addAttribute(output, Namespaces.XHTML, "property", "xhtml:property", xHtmlProperty);
		SaxContextHandler.addAttribute(output, Namespaces.XML, "id", "xml:id", xmlId);

		// attributes if header
		if(header) {
			SaxContextHandler.addAttribute(output, Namespaces.TEXT, "is-list-header", "text:is-list-header", isListHeader);
			SaxContextHandler.addAttribute(output, Namespaces.TEXT, "outline-level", "text:outline-level", outlineLevel);
			SaxContextHandler.addAttribute(output, Namespaces.TEXT, "restart-numbering", "text:restart-numbering", restartNumbering);
			SaxContextHandler.addAttribute(output, Namespaces.TEXT, "start-value", "text:start-value", startValue);
		}

		for(Object child:getContent()) {
			if(child instanceof IElementWriter) {
				((IElementWriter)child).writeObject(output);
			}
		}
		SaxContextHandler.endElement(output, Namespaces.TEXT, localName, qName);
	}
}
