/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.styles;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;
import org.apache.xml.serializer.SerializationHandler;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.SaxContextHandler;

final public class TableTemplate extends StyleBase {

    private HashMap<String, AttributesImpl> templateMap = new HashMap<String, AttributesImpl>();

    public TableTemplate(String styleName, AttributesImpl attributesImpl) {
	    super(styleName, attributesImpl, false, false, false);
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.startElement(output, getNamespace(), getLocalName(), getQName());
        output.addAttribute(Namespaces.TEXT, "style-name", "text:style-name", "", getName());
        attributes.write(output);
        final Iterator<Entry<String, AttributesImpl>> templateMapIter = templateMap.entrySet().iterator();
        while(templateMapIter.hasNext()) {
            final Entry<String, AttributesImpl> templateMapEntry = templateMapIter.next();
            SaxContextHandler.startElement(output, Namespaces.TABLE, templateMapEntry.getKey(), "table:" + templateMapEntry.getKey());
            templateMapEntry.getValue().write(output);
            SaxContextHandler.endElement(output, Namespaces.TABLE, templateMapEntry.getKey(), "table:" + templateMapEntry.getKey());
        }
		SaxContextHandler.endElement(output, getNamespace(), getLocalName(), getQName());
	}

	public HashMap<String, AttributesImpl> getTableTemplates() {
	    return templateMap;
	}

	@Override
	public void mergeAttrs(StyleBase styleBase) {
	    //
	}

	@Override
	public void applyAttrs(StyleManager styleManager, JSONObject attrs)    
	    throws JSONException {

	    final String parent;
	    if(attrs.has("wholeTable")) {
	        parent = "wholeTable";
	        insertTableTemplateStyle(styleManager, "wholeTable", "body", null, attrs);
	    }
	    else {
	        parent = null;
	    }
	    final Iterator<Entry<String, Object>> iter = attrs.entrySet().iterator();
	    while(iter.hasNext()) {
	        final Entry<String, Object> entry = iter.next();
	        final String conditionalStyle; 
	        switch(entry.getKey()) {
                case "firstCol": {
                    conditionalStyle = "first-column";
                    break;
                }
                case "lastCol": {
                    conditionalStyle = "last-column";
                    break;
                }
                case "firstRow": {
                    conditionalStyle = "first-row";
                    break;
                }
                case "lastRow": {
                    conditionalStyle = "last-row";
                    break;
                }
                case "band2Hor": {
                    conditionalStyle = "even-rows";
                    break;
                }
                case "band1Hor": {
                    conditionalStyle = "odd-rows";
                    break;
                }
                case "band2Vert": {
                    conditionalStyle = "even-columns";
                    break;
                }
                case "band1Vert": {
                    conditionalStyle = "odd-columns";
                    break;
                }
                default: {
                    conditionalStyle = null;
                    break;
                }
	        }
	        if(conditionalStyle!=null) {
	            insertTableTemplateStyle(styleManager, entry.getKey(), conditionalStyle, parent, attrs);
	        }
	    }
	}

	private void insertTableTemplateStyle(StyleManager styleManager, String sourceConditionalStyle, String destConditionalStyle, String parentConditionalStyle, JSONObject attrs)
	    throws JSONException {

	    AttributesImpl conditionalStyleAttributes = templateMap.get(destConditionalStyle);
        if(conditionalStyleAttributes==null) {
            conditionalStyleAttributes = new AttributesImpl();
            templateMap.put(destConditionalStyle, conditionalStyleAttributes);
        }
        final String cellStyleName = styleManager.getUniqueStyleName("table-cell", false);
        if(parentConditionalStyle!=null) {
            final StyleBase styleBase = styleManager.createStyleSheet("cell", cellStyleName, null, attrs.optJSONObject(parentConditionalStyle) , "default", false, true);
            styleBase.applyAttrs(styleManager, attrs.optJSONObject(sourceConditionalStyle));
            styleManager.addStyle(styleBase);
        }
        else {
            styleManager.insertStyleSheet("cell", cellStyleName, null, attrs.optJSONObject(sourceConditionalStyle), "default", false, true);
        }
        conditionalStyleAttributes.setValue(Namespaces.TABLE, "style-name", "table:style-name", cellStyleName);
	}

	@Override
	public void createAttrs(StyleManager styleManager, OpAttrs attrs) {
	    //
	}

	@Override
	protected int _hashCode() {
	    int hash = 0;
        final Iterator<Entry<String, AttributesImpl>> templateMapIter = templateMap.entrySet().iterator();
        while(templateMapIter.hasNext()) {
            final Entry<String, AttributesImpl> templateMapEntry = templateMapIter.next();
            hash ^= templateMapEntry.getKey().hashCode();
            hash ^= templateMapEntry.getValue().hashCode();
        }
	    return hash;
	}

	@Override
	protected boolean _equals(StyleBase e) {
		final TableTemplate other = (TableTemplate)e;
		if(templateMap.size()!=other.templateMap.size()) {
		    return false;
		}
		final Iterator<Entry<String, AttributesImpl>> templateMapIter = templateMap.entrySet().iterator();
        while(templateMapIter.hasNext()) {
            final Entry<String, AttributesImpl> templateMapEntry = templateMapIter.next();
            if(!other.templateMap.containsKey(templateMapEntry.getKey())) {
                return false;
            }
            if(!templateMapEntry.getValue().equals(other.templateMap.get(templateMapEntry.getKey()))) {
                return false;
            }
        }
		return true;
	}

	@Override
	public TableTemplate clone() {
		final TableTemplate clone = (TableTemplate)_clone();
		clone.templateMap = new HashMap<String, AttributesImpl>();
        final Iterator<Entry<String, AttributesImpl>> templateMapIter = templateMap.entrySet().iterator();
        while(templateMapIter.hasNext()) {
            final Entry<String, AttributesImpl> templateMapEntry = templateMapIter.next();
            clone.templateMap.put(templateMapEntry.getKey(), templateMapEntry.getValue().clone());
        }
		return clone;
	}

	@Override
	public String getNamespace() {
        return Namespaces.TABLE;
    }

	@Override
    public String getQName() {
        return "table:table-template";
    }

	@Override
    public String getLocalName() {
        return "table-template";
    }

    @Override
    public String getFamily() {
        return "table-template";
    }
}
