/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.odftoolkit.odfdom.IElementWriter;
import com.openexchange.office.filter.odf.AttributeImpl;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.DLList;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.styles.StyleManager;

final public class ChartProperties extends StylePropertiesBase {

    private final static HashMap<String, ArrayList<HandleInfo>> handles;

    private static void putHandle(String key, Object value, String targetMap, String targetKey, Object targetVal) {
        ArrayList<HandleInfo> list = handles.get(key);
        if (list == null) {
            list = new ArrayList<>();
            handles.put(key, list);
        }
        list.add(new HandleInfo(key, value.toString(), targetMap, targetKey, targetVal));
    }

    static {
        handles = new HashMap<>();

        putHandle("chart:percentage", true, "chart", "stacking", "percentStacked");
        putHandle("chart:stacked", true, "chart", "stacking", "stacked");
        putHandle("chart:interpolation", "cubic-spline", "chart", "curved", true);

        putHandle("chart:display-label", true, "axis", "label", true);

        putHandle("chart:data-label-number", "value", "series", "dataLabel", "value");
        putHandle("chart:data-label-number", "percentage", "series", "dataLabel", "percent");
        putHandle("chart:data-label-number", "value-and-percentage", "series", "dataLabel", "value;percent");

    }

    private DLList<IElementWriter> content;

    public ChartProperties(AttributesImpl attributesImpl) {
        super(attributesImpl);
    }

    @Override
    public DLList<IElementWriter> getContent() {
        if (content == null) {
            content = new DLList<IElementWriter>();
        }
        return content;
    }

    @Override
    public String getQName() {
        return "style:chart-properties";
    }

    @Override
    public String getLocalName() {
        return "chart-properties";
    }

    @Override
    public String getNamespace() {
        return Namespaces.STYLE;
    }

    @Override
    public void applyAttrs(StyleManager styleManager, JSONObject attrs) {

    }

    @Override
    public void createAttrs(StyleManager styleManager, boolean contentAutoStyle, OpAttrs attrs) {
        Map<String, AttributeImpl> map = attributes.getUnmodifiableMap();

        for (String key : map.keySet()) {
            ArrayList<HandleInfo> handleList = handles.get(key);
            if (handleList != null) {
                for (HandleInfo handle : handleList) {
                    if (StringUtils.equals(attributes.getValue(key), handle.value)) {
                        OpAttrs target = attrs.getMap(handle.targetMap, true);
                        target.put(handle.targetKey, handle.targetVal);
                    }
                }
            }
        }
    }

    @Override
    public ChartProperties clone() {
        return (ChartProperties) _clone();
    }

    private static class HandleInfo {

        private final String key;
        private final String value;
        private final String targetMap;
        private final String targetKey;
        private final Object targetVal;

        HandleInfo(String key, String value, String targetMap, String targetKey, Object targetVal) {
            this.key = key;
            this.value = value;
            this.targetMap = targetMap;
            this.targetKey = targetKey;
            this.targetVal = targetVal;
        }

    }
}
