/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.draw;

import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.Attributes;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class CustomShape extends Shape {

    private EnhancedGeometry enhancedGeometry;

    public CustomShape(String documentType, boolean rootShape) {
        super(documentType, Namespaces.DRAW, "custom-shape", "draw:custom-shape", rootShape);
    }

    public CustomShape(Attributes attributes, boolean rootShape) {
        super(attributes, Namespaces.DRAW,"custom-shape", "draw:custom-shape", rootShape);
    }

    @Override
    public DrawingType getType() {
        return DrawingType.SHAPE;
    }

    public EnhancedGeometry getEnhancedGeometry(boolean forceCreate) {
        if(enhancedGeometry==null&&forceCreate) {
            enhancedGeometry = new EnhancedGeometry();
            getContent().add(enhancedGeometry);
        }
        return enhancedGeometry;
    }

    @Override
    public void applyAttrsFromJSON(OdfOperationDoc operationDocument, JSONObject attrs, boolean contentAutoStyle)
        throws JSONException {

        super.applyAttrsFromJSON(operationDocument, attrs, contentAutoStyle);

        final JSONObject geometryAttrs = attrs.optJSONObject("geometry");
        if(geometryAttrs!=null) {
            final Object hostData = geometryAttrs.opt("hostData");
            if(hostData instanceof String) {
                getEnhancedGeometry(true).setShapeData((String)hostData);
            }
            else if(hostData==JSONObject.NULL) {
                getEnhancedGeometry(true).setShapeData(null);
            }
            else {
                final Object presetShape = geometryAttrs.opt("presetShape");
                if(presetShape instanceof String) {
                    getEnhancedGeometry(true).setCustomShapeType((String)presetShape, true);
                }
            }
        }
        final JSONObject drawingAttrs = attrs.optJSONObject("drawing");
        if(drawingAttrs!=null) {
            final Object flipH = drawingAttrs.opt("flipH");
            if(flipH!=null) {
                getEnhancedGeometry(true).setFlipH(flipH instanceof Boolean ? (Boolean)flipH : null);
            }
            final Object flipV = drawingAttrs.opt("flipV");
            if(flipV!=null) {
                getEnhancedGeometry(true).setFlipV(flipV instanceof Boolean ? (Boolean)flipV : null);
            }
        }
    }

    @Override
    public void createAttrs(OdfOperationDoc operationDocument, OpAttrs attrs, boolean contentAutoStyle) {
        super.createAttrs(operationDocument, attrs, contentAutoStyle);

        if(enhancedGeometry!=null) {
            final Map<String, Object> geometryAttrs = attrs.getMap("geometry", true);
            final String predefinedShape = enhancedGeometry.getPredefinedShape();
            if(predefinedShape!=null) {
                geometryAttrs.put("presetShape", predefinedShape);
            }
            final String shapeData = enhancedGeometry.getShapeData();
            if(shapeData!=null) {
                geometryAttrs.put("hostData", shapeData);
            }
            final Boolean flipH = enhancedGeometry.getFlipH();
            if(flipH!=null) {
                attrs.getMap("drawing", true).put("flipH", flipH);
            }
            final Boolean flipV = enhancedGeometry.getFlipV();
            if(flipV!=null) {
                attrs.getMap("drawing", true).put("flipV", flipV);
            }
        }
    }

    @Override
    public SaxContextHandler getContextHandler(SaxContextHandler parentHandler) {
        return new CustomShapeHandler(parentHandler, this);
    }
}
