/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 *
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.components;

import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.odf.DLList;
import com.openexchange.office.filter.odf.DLNode;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odt.dom.Hyperlink;
import com.openexchange.office.filter.odt.dom.Paragraph;
import com.openexchange.office.filter.odt.dom.TextSpan;

public abstract class TextSpan_Base extends Component {

    public TextSpan_Base(ComponentContext parentContext, DLNode<Object> _textNode, int _componentNumber) {
        super(parentContext, _textNode, _componentNumber);
    }

    public TextSpan getTextSpan() {
    	return (TextSpan)getTextSpanNode().getObject();
    }

    public DLNode<Object> getTextSpanNode() {
    	return getParentContext().getNode();
    }

	protected void splitTextSpan(boolean before) {
		final DLNode<Object> refNode = getNode();
		final TextSpan textSpan = getTextSpan();
		final DLNode<Object> textSpanNode = getTextSpanNode();
		final DLList<Object> textSpanContent = ((TextSpan)textSpanNode.getObject()).getContent();
		final DLList<Object> paragraphContent = ((Paragraph)getParentContext().getParentContext().getNode().getObject()).getContent();
		if(before&&refNode.prev!=null) {
			final TextSpan destTextSpan = textSpan.clone();
			final DLNode<Object> destTextSpanNode = new DLNode<Object>(destTextSpan);
			paragraphContent.addNode(textSpanNode, destTextSpanNode, true);

			DLNode<Object> currentNode = textSpanContent.getFirstNode();
			while(currentNode!=refNode) {
				textSpanContent.removeNode(currentNode);
				destTextSpan.getContent().addNode(currentNode);
				currentNode = textSpanContent.getFirstNode();
			}
		}
		else if(!before&&refNode.next!=null) {
			final TextSpan destTextSpan = textSpan.clone();
			final DLNode<Object> destTextSpanNode = new DLNode<Object>(destTextSpan);
			paragraphContent.addNode(textSpanNode, destTextSpanNode, false);

			while(refNode.next!=null) {
				destTextSpan.getContent().addNode(textSpanContent.removeNode(refNode.next));
			}
		}
    }

	@Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
		return null;
	}

	@Override
	public void applyAttrsFromJSON(OdfOperationDoc operationDocument, JSONObject attrs)
		throws JSONException {

		if(attrs==null||attrs.isEmpty()) {
			return;
		}

		final TextSpan textSpan = getTextSpan();
		textSpan.setStyleName(operationDocument.getDocument().getStyleManager().applyAttributes("text", textSpan.getStyleName(), isContentAutoStyle(), attrs));

		final JSONObject characterAttrs = attrs.optJSONObject("character");
		if(characterAttrs!=null) {
			final Object url = characterAttrs.opt("url");
			if(url instanceof String) {
				textSpan.getHyperlink(Namespaces.TEXT, true).setHRef((String)url);
			}
			else if(url==JSONObject.NULL) {
				textSpan.setHyperlink(null);
			}
		}
	}

	@Override
	public void createAttrs(OdfOperationDoc operationDocument, OpAttrs attrs) {

		final TextSpan textSpan = (TextSpan)getParentContext().getNode().getObject();
		if(textSpan.getStyleName()!=null) {
			operationDocument.getDocument().getStyleManager().
				createAutoStyleAttributes(attrs, textSpan.getStyleName(), "text", isContentAutoStyle());
		}
		final Hyperlink hyperlink = textSpan.getHyperlink(null, false);
		if(hyperlink!=null) {
			if(hyperlink.getHRef()!=null) {
				attrs.getMap("character", true).put("url", hyperlink.getHRef());
			}
		}
		return;
	}

	@Override
	public void splitStart(int n) {
    	splitTextSpan(true);
	}

	@Override
	public void splitEnd(int n) {
    	splitTextSpan(false);
	}
}
