/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import org.apache.commons.io.IOUtils;

import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.api.FilterException.ErrorCode;

public class DocumentComplexity {

    public static InputStream checkDocumentComplexity(InputStream _inputStream, long maxAllowedXmlSizeMatchingComplexity, long maxAllowedXmlSizeMatchingMemory)
       	throws FilterException {

    	InputStream returnValue = null;

        int xmlFileSize = 0;

        byte[] bytes;

        try {
			bytes = IOUtils.toByteArray(_inputStream);
		} catch (IOException e1) {
            throw new FilterException("", ErrorCode.COMPLEXITY_TOO_HIGH);
		} finally {
	        IOUtils.closeQuietly(_inputStream);
		}

        final InputStream _zipInputStream = new ByteArrayInputStream(bytes);
        final ZipInputStream zipInputStream = new ZipInputStream(_zipInputStream);

        ZipEntry zipEntry = null;
        final byte[] buffer = new byte[0x10000];  // 64kb buffer

        try {
			while((zipEntry = zipInputStream.getNextEntry())!=null) {

				int read;

				final String zipEntryName = zipEntry.getName();
				if(zipEntryName.endsWith(".xml")) {
		        	while((read = zipInputStream.read(buffer))>=0) {
		        		xmlFileSize += read;
		        	}
		        }
			    zipInputStream.closeEntry();
			    if((maxAllowedXmlSizeMatchingComplexity>0)&&(xmlFileSize>maxAllowedXmlSizeMatchingComplexity)) {
		            throw new FilterException("", ErrorCode.COMPLEXITY_TOO_HIGH);
			    }
			}
            if((maxAllowedXmlSizeMatchingMemory>0)&&(xmlFileSize>maxAllowedXmlSizeMatchingMemory)) {
                throw new FilterException("", ErrorCode.COMPLEXITY_TOO_HIGH, (long)(maxAllowedXmlSizeMatchingMemory));
            }
			returnValue = new ByteArrayInputStream(bytes);
        } catch (IOException e) {
            throw new FilterException("", ErrorCode.COMPLEXITY_TOO_HIGH);
		} finally {
			try {
				zipInputStream.close();
			} catch (IOException e) {

			}
			IOUtils.closeQuietly(_zipInputStream);
		}
        return returnValue;
    }
}
