package com.openexchange.office.fields;

import java.util.HashMap;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONObject;

public class FieldsHandlerText
        implements
        FieldsHandler
{

    @Override
    public JSONArray getMergeOperations(
        JSONArray ops,
        Map<String, Object> fields)
        throws Exception
    {
        JSONArray newOps = new JSONArray();

        Map<JSONArray, JSONObject> insertFields = new HashMap<JSONArray, JSONObject>(fields.size());

        for (int i = 0; i < ops.length(); i++)
        {
            JSONObject op = ops.getJSONObject(i);
            String name = op.getString("name");

            if (name.equals("insertField") && op.optString("type", "").equals("database-display")) {

            	insertFields.put(op.getJSONArray("start"), op);

            } else if (name.equals("setAttributes")) {

            	JSONArray start = op.optJSONArray("start");

            	JSONObject insertField = insertFields.get(start);

            	if (null != insertField) {
            		insertFields.remove(start);

            		String columnName = op.getJSONObject("attrs").getJSONObject("character").getJSONObject("field").optString("text:column-name", "");
            		Object value = fields.get(columnName);

            		if (value != null) {

            			System.out.println(columnName + " -> " + start + " " + value);

            			JSONObject del = new JSONObject();
            			del.put("name", "delete");
                        del.put("start", start);
                        del.put("end", start);

                        insertField.put("representation", value.toString());

                        newOps.put(del);
                        newOps.put(insertField);
                        newOps.put(op);
            		}
            	}

            }

        }
        return newOps;
    }
}
