/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package org.xlsx4j.sml;

import java.util.Iterator;
import java.util.List;

public class CfRule {

	public class CfRuleIter implements Iterator<ICfRule>{

		private ICfRule r1;
		private ICfRule r2;

		CfRuleIter(CfRule cfRule) {
			this.r1 = cfRule.getR1();
			this.r2 = cfRule.getR2();
		}

		@Override
		public boolean hasNext() {
			return r1!=null||r2!=null;
		}

		@Override
		public ICfRule next() {
			ICfRule ret = null;
			if(r1!=null) {
				ret = r1;
				r1 = null;
			}
			else {
				ret = r2;
				r2 = null;
			}
			return ret;
		}

		@Override
		public void remove() {
			throw new UnsupportedOperationException();
		}
	}

	private List<String> ranges;
	private CTCfRule r1;
	private org.xlsx4j.schemas.microsoft.com.office.spreadsheetml_2009_9.main.CTCfRule r2;

	public CfRule(CTCfRule r1, List<String> ranges) {
		this.r1 = r1;
		this.r2 = null;
		this.ranges = ranges;
	}

	public CfRule(org.xlsx4j.schemas.microsoft.com.office.spreadsheetml_2009_9.main.CTCfRule r2, List<String> ranges) {
		this.r1 = null;
		this.r2 = r2;
		this.ranges = ranges;
	}

	public String getType() {
		if(r1!=null&&r2==null) {
			return "A";
		}
		else if(r1==null&&r2!=null) {
			return "B";
		}
		return "C";
	}

	public List<String> getRanges() {
		return ranges;
	}

	public void setRanges(List<String> ranges) {
		this.ranges = ranges;
	}

	public CTCfRule getR1() {
		return r1;
	}

	public org.xlsx4j.schemas.microsoft.com.office.spreadsheetml_2009_9.main.CTCfRule getR2() {
		return r2;
	}

	public void setR2(org.xlsx4j.schemas.microsoft.com.office.spreadsheetml_2009_9.main.CTCfRule r2) {
		this.r2 = r2;
	}

	public CfRuleIter iterator() {
		return new CfRuleIter(this);
	}
}
