/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package org.xlsx4j.sml;

public class CellRep {

    protected Object column;

    /*
     * type represented by the combination
     * of following features that were supported:
     * 
     * bit 0==1 -> value is supported
     * bit 1==1 -> whitespace preserved (only if bit 0==1)
     * bit 2==1 -> formula is supported
     * 
     */

    public int getType() {
    	return 0;
    }

    public Integer getColumn() {
    	if (column instanceof String) {
    		column = SmlUtils.createCellRef((String)column).getColumn();
    	}
        return (Integer)column;
    }

    public void setColumn(int _column) {
    	column = Integer.valueOf(_column);
    }

    public String getR() {
    	return (String)column;
    }

    public void setR(String r) {
    	column = r;
    }

    public CellRep createNewCellRep(int newType) {
    	final int currentType = getType();
    	if(currentType==newType) {
    		return this;
    	}
    	CellRep newCellRep = null;
    	switch(newType) {
    		case 0 : {
    			newCellRep = new CellRep();
    			break;
    		}
    		case 1 : {
    			newCellRep = new CellRepV();
    			break;
    		}
    		case 3 : {
    			newCellRep = new CellRepPreserveV();
    			break;
    		}
    		case 4 : {
    			newCellRep = new CellRepF();
    			break;
    		}
    		case 5 : {
    			newCellRep = new CellRepVF();
    			break;
    		}
    		case 7 : {
    			newCellRep = new CellRepPreserveVF();
    			break;
    		}
    	}
    	newCellRep.column = column;

    	if(newCellRep instanceof iCellRepV && this instanceof iCellRepV) {
    		((iCellRepV)newCellRep).setV((((iCellRepV)this).getV()));
    	}
    	if(newCellRep instanceof iCellRepF && this instanceof iCellRepF) {
    		((iCellRepF)newCellRep).setF((((iCellRepF)this).getF()));
    	}
    	return newCellRep;
    }
}
