package org.docx4j.model.datastorage;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBElement;

import org.docx4j.TraversalUtil.CallbackImpl;
import org.docx4j.XmlUtils;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkRenumber {
	
/*
 * Note that where the input docx contains:
 * 
        <w:bookmarkStart w:id="309" w:name="_Ref353188010" w:displacedByCustomXml="next"/>
        
        <w:sdt>
          <w:sdtPr>
            <w:alias w:val="Data value: lF2HS"/>
            <w:tag w:val="od:repeat=lF2HS"/>
            <w:id w:val="-414473234"/>
          </w:sdtPr>
          <w:sdtContent>
          
            <w:bookmarkEnd w:id="309" w:displacedByCustomXml="prev"/>
            
   A new start element will be created inside the sdtContent.
   
   So later, we may need to sweep through and remove the original bookmarkStart w:id="309",
   since it won't have a matching end tag anymore.
               
            
             */
	
	protected static Logger log = LoggerFactory.getLogger(BookmarkRenumber.class);	
	
	//             fixRange( blockRange, "CTBookmark", "CTMarkupRange", null);
        
        static class RangeTraverser extends CallbackImpl {
			
        	List<Object> starts = new ArrayList<Object>();
        	List<Object> ends   = new ArrayList<Object>();
        	List<Object> refs   = new ArrayList<Object>();
        	List<CTBookmark> deletes   = new ArrayList<CTBookmark>();
        	
        	String startElement; 
        	String endElement; 
        	String refElement;
        	
        	RangeTraverser(String startElement, String endElement, String refElement) {
        		
        		this.startElement = "org.docx4j.wml." + startElement;
        		this.endElement   = "org.docx4j.wml." + endElement;
        		this.refElement   = "org.docx4j.wml." + refElement;        		
        	}

        	@Override
			public List<Object> apply(Object o) {
        		
				if (o.getClass().getName().equals(startElement)) {
					if (o instanceof CTBookmark) { // check for special case
						CTBookmark bookmark = (CTBookmark)o;
						if (bookmark.getName().equals("_GoBack")) {
							deletes.add(bookmark);
						} else {
							starts.add(o);							
						}
					} else {
						starts.add(o);
					}
				}
				
				if (o.getClass().getName().equals(endElement)) {
					ends.add(o);
				}

				if (o.getClass().getName().equals(refElement)) {
					refs.add(o);
				} else if (startElement.equals("org.docx4j.wml.CTBookmark") 
						&& o instanceof javax.xml.bind.JAXBElement
						&& ((JAXBElement)o).getName().getLocalPart().equals("instrText")) {
					refs.add( XmlUtils.unwrap(o) );
				}
				
				return null;
			}
        	
        	@Override // to setParent
    		public void walkJAXBElements(Object parent) {
    			
    			List children = getChildren(parent);
    			if (children != null) {

    				for (Object o : children) {
    					
    					if (o instanceof javax.xml.bind.JAXBElement
    							&& ((JAXBElement)o).getName().getLocalPart().equals("instrText")) {
    						// preserve this, but set its parent
    						Text t = (Text)XmlUtils.unwrap(o);
    						t.setParent(parent);
    					} else {    					
    						o = XmlUtils.unwrap(o);
    					}
    					
    					// workaround for broken getParent (since 3.0.0)
    					if (o instanceof Child) {
    						((Child)o).setParent(parent);
    					}
    					
    					this.apply(o);

    					if (this.shouldTraverse(o)) {
    						walkJAXBElements(o);
    					}

    				}
    			}
    		}        	
		}
}
