
/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.docx4j.dml.chartex2014;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.docx4j.dml.CTColorMapping;
import org.docx4j.dml.CTShapeProperties;
import org.docx4j.dml.CTTextBody;


/**
 * <p>Java class for CT_ChartSpace complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CT_ChartSpace">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="chartData" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_ChartData"/>
 *         &lt;element name="chart" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_Chart"/>
 *         &lt;element name="spPr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_ShapeProperties" minOccurs="0"/>
 *         &lt;element name="txPr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_TextBody" minOccurs="0"/>
 *         &lt;element name="clrMapOvr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_ColorMapping" minOccurs="0"/>
 *         &lt;element name="fmtOvrs" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_FormatOverrides" minOccurs="0"/>
 *         &lt;element name="printSettings" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_PrintSettings" minOccurs="0"/>
 *         &lt;element name="extLst" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_ExtensionList" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_ChartSpace", propOrder = {
    "chartData",
    "chart",
    "spPr",
    "txPr",
    "clrMapOvr",
    "fmtOvrs",
    "printSettings",
    "extLst"
})
@XmlRootElement(name = "chartSpace")
public class CTChartSpace {

    @XmlElement(required = true)
    protected CTChartData chartData;
    @XmlElement(required = true)
    protected CTChart chart;
    protected CTShapeProperties spPr;
    protected CTTextBody txPr;
    protected CTColorMapping clrMapOvr;
    protected CTFormatOverrides fmtOvrs;
    protected CTPrintSettings printSettings;
    protected CTExtensionList extLst;

    /**
     * Gets the value of the chartData property.
     * 
     * @return
     *     possible object is
     *     {@link CTChartData }
     *     
     */
    public CTChartData getChartData() {
        return chartData;
    }

    /**
     * Sets the value of the chartData property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTChartData }
     *     
     */
    public void setChartData(CTChartData value) {
        this.chartData = value;
    }

    /**
     * Gets the value of the chart property.
     * 
     * @return
     *     possible object is
     *     {@link CTChart }
     *     
     */
    public CTChart getChart() {
        return chart;
    }

    /**
     * Sets the value of the chart property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTChart }
     *     
     */
    public void setChart(CTChart value) {
        this.chart = value;
    }

    /**
     * Gets the value of the spPr property.
     * 
     * @return
     *     possible object is
     *     {@link CTShapeProperties }
     *     
     */
    public CTShapeProperties getSpPr() {
        return spPr;
    }

    /**
     * Sets the value of the spPr property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTShapeProperties }
     *     
     */
    public void setSpPr(CTShapeProperties value) {
        this.spPr = value;
    }

    /**
     * Gets the value of the txPr property.
     * 
     * @return
     *     possible object is
     *     {@link CTTextBody }
     *     
     */
    public CTTextBody getTxPr() {
        return txPr;
    }

    /**
     * Sets the value of the txPr property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTTextBody }
     *     
     */
    public void setTxPr(CTTextBody value) {
        this.txPr = value;
    }

    /**
     * Gets the value of the clrMapOvr property.
     * 
     * @return
     *     possible object is
     *     {@link CTColorMapping }
     *     
     */
    public CTColorMapping getClrMapOvr() {
        return clrMapOvr;
    }

    /**
     * Sets the value of the clrMapOvr property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTColorMapping }
     *     
     */
    public void setClrMapOvr(CTColorMapping value) {
        this.clrMapOvr = value;
    }

    /**
     * Gets the value of the fmtOvrs property.
     * 
     * @return
     *     possible object is
     *     {@link CTFormatOverrides }
     *     
     */
    public CTFormatOverrides getFmtOvrs() {
        return fmtOvrs;
    }

    /**
     * Sets the value of the fmtOvrs property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTFormatOverrides }
     *     
     */
    public void setFmtOvrs(CTFormatOverrides value) {
        this.fmtOvrs = value;
    }

    /**
     * Gets the value of the printSettings property.
     * 
     * @return
     *     possible object is
     *     {@link CTPrintSettings }
     *     
     */
    public CTPrintSettings getPrintSettings() {
        return printSettings;
    }

    /**
     * Sets the value of the printSettings property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTPrintSettings }
     *     
     */
    public void setPrintSettings(CTPrintSettings value) {
        this.printSettings = value;
    }

    /**
     * Gets the value of the extLst property.
     * 
     * @return
     *     possible object is
     *     {@link CTExtensionList }
     *     
     */
    public CTExtensionList getExtLst() {
        return extLst;
    }

    /**
     * Sets the value of the extLst property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTExtensionList }
     *     
     */
    public void setExtLst(CTExtensionList value) {
        this.extLst = value;
    }

}
