/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.backup.restore;

import com.openexchange.office.tools.error.ErrorCode;

/**
 *
 * @author carsten-driesner
 *
 */
public class RestoreData {
    public final static String KEY_RESTORE_FILENAME  = "restoredFileName";
    public final static String KEY_RESTORE_FILEID    = "restoredFileId";
    public final static String KEY_RESTORE_FOLDERID  = "restoredFolderId";
    public final static String KEY_RESTORE_ERRORCODE = "restoredErrorCode";

    private ErrorCode errorCode;
    private String restoredFileName;
    private String restoredFileId;
    private String restoredFolderId;

    public RestoreData(final ErrorCode errorCode, final String restoredFileName, final String fileId, final String folderId) {
        this.errorCode = errorCode;
        this.restoredFileName = restoredFileName;
        this.restoredFileId = fileId;
        this.restoredFolderId = folderId;
    }

    public ErrorCode getErrorCode() { return errorCode; }

    public String getRestoredFileName() { return restoredFileName; }

    public String getRestoredFileId() { return restoredFileId; }

    public String getRestoredFolderId() { return restoredFolderId; }

    public void setErrorCode(final ErrorCode errorCode) { this.errorCode = errorCode; }

    public void setRestoredFileName(final String restoredFileName) { this.restoredFileName = restoredFileName; }

    public void setRestoredFileId(final String restoredFileId) { this.restoredFileId = restoredFileId; }

    public void setRestoredFolderId(final String restoredFolderId) { this.restoredFolderId = restoredFolderId; }
}
