/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/textframework/view/view', [
    'io.ox/office/editframework/view/editview',
    'less!io.ox/office/textframework/view/style'
], function (EditView) {

    'use strict';

    // class TextBaseView =====================================================

    /**
     * Generic base class of a view for a document using the text framework.
     *
     * @constructor
     *
     * @extends EditView
     *
     * @param {EditApplication} app
     *  The application instance containing this view.
     *
     * @param {Editor} docModel
     *  The document model created by the passed application.
     *
     * @param {Object} [initOptions]
     *  Optional parameters that will be passed to the constructor of the base
     *  class EditView.
     */
    var TextBaseView = EditView.extend({ constructor: function (app, docModel, initOptions) {

        // base constructors --------------------------------------------------

        EditView.call(this, app, docModel, initOptions);

        // initialization -----------------------------------------------------

    } }); // class TextBaseView

    // exports ================================================================

    return TextBaseView;

});
