/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Peter Seliger <peter.seliger@open-xchange.com>
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/text/app/mailcomposemodification', [

    'io.ox/office/tk/utils',
    'io.ox/core/extensions',
    'io.ox/files/api'

], function (Utils, CoreExtensions, FilesApi) {

    'use strict';

    Utils.info('... documents module "mailcomposemodification" is loading ...');

    function collectToBeDeletedItemsAfterMailComposeFromAttachmentModelList(collector, attachmentModel) {
        var disp     = attachmentModel.get('disp');
        var isDelete = attachmentModel.get('is_delete_after_mail_compose');

        if ((isDelete === true) && (disp === 'attachment')) {
            collector.push({
                id:         attachmentModel.get('id'),
                folder_id:  attachmentModel.get('folder_id')
            });
        }
        return collector;
    }

    function isToBeDeletedAttachmentAfterMailCompose(attachment/*, idx, list*/) {
        return (
            (attachment.is_delete_after_mail_compose === true) &&
            (attachment.disp === 'attachment')
        );
    }

    var extensionPointComposeButtons = CoreExtensions.point('io.ox/mail/compose/buttons');

    /**
     *  modify extension point id 'discard' as of file 'io.ox/mail/compose/view':
     *
     *  - line 51 / code block:
     *    {
     *       index: 300,
     *       id: 'discard',
     *       draw: extensions.buttons.discard
     *    }
     */
    extensionPointComposeButtons.disable('discard');
    extensionPointComposeButtons.extend({
        id: 'ox-text-discard',
        index: 300,
        draw: function (baton) {
            // Utils.info('mailcomposemodification :: ox-text-discard :: draw :: [baton] : ', baton);
            // Utils.info('mailcomposemodification :: ox-text-discard :: draw :: [$target] : ', this);
            var $target = this;       // <div ... data-extension-id="header" ... />
            var argsArr = arguments;

            var attachmentModelList = baton.model.get('attachments');
            var toBeDeletedItemList = attachmentModelList.models.reduce(collectToBeDeletedItemsAfterMailComposeFromAttachmentModelList, []);

            extensionPointComposeButtons.get('discard', function (discard) { // `discard.draw` here is the proceed method.
                discard.draw.apply($target, argsArr);
            });

            attachmentModelList.listenTo(attachmentModelList, 'remove', function (attachment) {
                // Utils.info('++++ remove event +++ attachment : ', attachment);
                var
                    list = toBeDeletedItemList.filter(function (item) {
                        return (item.id === attachment.id);
                    });

                if (list.length) {
                    Utils.info('+++ documents mailcomposemodification +++ model.discard +++ found items for delete +++');
                    toBeDeletedItemList = toBeDeletedItemList.filter(function (item) {
                        return (item.id !== attachment.id);
                    });
                    FilesApi.remove(list, true);
                }
            });

            /**
             *  modify a mail compose model instance's 'discard' method  as of file ''io.ox/mail/compose/model'':
             *
             *  - line 344 / code block:
             *
             *  discard: function () {
             *    // never delete on edit
             *    // only delete autosaved drafts that are not saved manually and have a msgref
             *    if (this.get('autoDismiss')) return;
             *    if (this.get('autosavedAsDraft') && this.get('msgref')) mailAPI.remove([mailUtil.parseMsgref(mailAPI.separator, this.get('msgref'))]);
             *  },
             */
            baton.model.discard = _.wrap(baton.model.discard, function (proceed) {
                var model = this;

                // Utils.info('+++ documents mailcomposemodification +++ model.discard +++');
                // Utils.info('+++ documents mailcomposemodification +++ documents model.get("autoDismiss") : ', model.get('autoDismiss'));

                // if ((model.get('autoDismiss') === false) && (toBeDeletedItemList.length >= 1)) {
                if (toBeDeletedItemList.length >= 1) {
                    Utils.info('+++ documents mailcomposemodification +++ model.discard +++ found items for delete +++');

                    FilesApi.remove(toBeDeletedItemList, true);
                }
                return proceed.call(model);
            });

            /**
             *  modify a mail compose model instance's 'getMailForDraft' method  as of file ''io.ox/mail/compose/model'':
             *
             *  - line 316 / code block:
             *
             *  getMailForDraft: function () {
             *    var mail = this.getMail();
             *
             *    if (_(mail.flags).isUndefined()) {
             *      mail.flags = mailAPI.FLAGS.DRAFT;
             *    } else if ((mail.data.flags & 4) === 0) {
             *      mail.flags += mailAPI.FLAGS.DRAFT;
             *    }
             *
             *    return mail;
             *  }
             */
            baton.model.getMailForDraft = _.wrap(baton.model.getMailForDraft, function (proceed) {
                var model = this;

                // Utils.info('+++ documents mailcomposemodification +++ model.getMailForDraft +++');
                // Utils.info('+++ documents mailcomposemodification +++ model.get("autoDismiss") : ', model.get('autoDismiss'));

                var result = proceed.call(model); // mail

                // if ((model.get('autoDismiss') === true) && (toBeDeletedItemList.length >= 1)) {
                if (toBeDeletedItemList.length >= 1) {

                    Utils.info('+++ documents mailcomposemodification +++ model.getMailForDraft +++ found items for delete +++');

                  //window.setTimeout((function (FilesApi, toBeDeletedItemList) {
                  //    return function () {
                  //
                  //        FilesApi.remove(toBeDeletedItemList, true);
                  //    };
                  //}(FilesApi, toBeDeletedItemList)), 1000);

                    _.defer(function () {

                        FilesApi.remove(toBeDeletedItemList, true);

                    }, 1000);
                }
                return result; // mail
            });
        }
    });

    // workaround for Bug 52872, there was no extension for errorhandling if email could not be sent
    CoreExtensions.point('io.ox/mail/compose/actions/send').extend({
        id: 'ox-text-send',
        index: 20000,
        perform: function (baton) {
            if (baton.error) {
                Utils.info('+++ documents mailcomposemodification +++ "io.ox/mail/compose/actions/send" perform triggered with an error in baton -> dont delete temporary files! +++');
            } else {
                var attachmentList = baton.mail.attachments.filter(isToBeDeletedAttachmentAfterMailCompose);
                FilesApi.remove(attachmentList, true);
            }
        }
    });

});
