/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/utils/operations', [
    'io.ox/office/textframework/utils/operations'
], function (BaseTextOperations) {

    'use strict';

    // static class SpreadsheetOperations =====================================

    /**
     * Provides constants for the names of all document operations used in
     * spreadsheet documents.
     *
     * @extends BaseTextOperations
     */
    var SpreadsheetOperations = BaseTextOperations.extend({

        INSERT_NUMBER_FORMAT: 'insertNumberFormat',
        DELETE_NUMBER_FORMAT: 'deleteNumberFormat',

        INSERT_SHEET: 'insertSheet',
        DELETE_SHEET: 'deleteSheet',
        CHANGE_SHEET: 'setSheetAttributes',
        RENAME_SHEET: 'setSheetName',
        MOVE_SHEET: 'moveSheet',
        COPY_SHEET: 'copySheet',

        CHANGE_CELLS: 'changeCells',
        MOVE_CELLS: 'moveCells',
        MERGE_CELLS: 'mergeCells',

        INSERT_HYPERLINK: 'insertHyperlink',
        DELETE_HYPERLINK: 'deleteHyperlink',

        INSERT_COLUMNS: 'insertColumns',
        DELETE_COLUMNS: 'deleteColumns',
        CHANGE_COLUMNS: 'changeColumns',

        INSERT_ROWS: 'insertRows',
        DELETE_ROWS: 'deleteRows',
        CHANGE_ROWS: 'changeRows',

        INSERT_NAME: 'insertName',
        CHANGE_NAME: 'changeName',
        DELETE_NAME: 'deleteName',

        INSERT_TABLE: 'insertTable',
        CHANGE_TABLE: 'changeTable',
        DELETE_TABLE: 'deleteTable',
        CHANGE_TABLE_COLUMN: 'changeTableColumn',

        INSERT_VALIDATION: 'insertValidation',
        CHANGE_VALIDATION: 'changeValidation',
        DELETE_VALIDATION: 'deleteValidation',

        INSERT_CFRULE: 'insertCFRule',
        CHANGE_CFRULE: 'changeCFRule',
        DELETE_CFRULE: 'deleteCFRule'
    });

    // exports ================================================================

    return SpreadsheetOperations;

});
