/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/editframework/view/dialog/saveastemplatedialog', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/io',
    'io.ox/office/tk/utils/driveutils',
    'io.ox/office/settings/templatemodel',
    'io.ox/office/settings/contexttemplatemodel',
    'io.ox/office/editframework/view/editlabels',
    'io.ox/office/editframework/view/dialog/saveasfiledialog'
], function (Utils, IO, DriveUtils, TemplateModel, ContextTemplateModel, Labels, SaveAsFileDialog) {

    'use strict';

    // settings key for the last used folder
    var RECENT_FOLDER_KEY = 'recentSaveAsTemplate';

    // class SaveAsTemplateDialog =============================================

    /**
     * @constructor
     *
     * @extends SaveAsFileDialog
     *
     * @param {EditView} docView
     *  The document view instance that has created this dialog.
     *
     * @param {Object} [initOptions]
     *  Optional parameters that control the appearance and behavior of the
     *  dialog. Supports all options also supported by the base class
     *  SaveAsFileDialog. Additionally, the following options are supported:
     *  @param {String} [initOptions.value='']
     *      The initial value of the text field.
     *  @param {String} [initOptions.placeholder='']
     *      The place-holder text that will be shown in the empty text field.
     *  @param {Boolean} [initOptions.allowEmpty=false]
     *      If set to true, empty text will be considered valid. Otherwise, the
     *      primary button will be disabled as long as the text input field is
     *      empty.
     */
    var SaveAsTemplateDialog = SaveAsFileDialog.extend({ constructor: function (docView, initOptions) {

        var self = this;

        var app = docView.getApp();

        var recentTemplateFolder = app.getUserSettingsValue(RECENT_FOLDER_KEY, DriveUtils.getStandardTemplateFolderId());

        var folderPicker = new DriveUtils.FlatFolderPicker(docView, { preselect: Utils.getStringOption(initOptions, 'preselect', recentTemplateFolder) });

        // base constructor ---------------------------------------------------

        SaveAsFileDialog.call(this, docView, Utils.extendOptions(initOptions, { folderPicker: folderPicker }));

        // initialization -----------------------------------------------------

        var myFolders = [DriveUtils.getStandardTemplateFolderId()];
        myFolders = myFolders.concat(new TemplateModel('MyTemplateFolders').getAll());
        myFolders = _.unique(myFolders);
        folderPicker.addFolders(Labels.USER_TEMPLATE_FOLDER, myFolders);

        IO.sendRequest(IO.FILTER_MODULE_NAME, { action: 'getcontexttemplatefolders' }).done(function (data) {
            folderPicker.addFolders(Labels.GLOBAL_TEMPLATE_FOLDER, new ContextTemplateModel(data).getAll());
        });

        this.on('triggered', function (evt, action) {
            if (action === 'ok') {
                var selectedFolder = self.getSelectedFolderId();
                if (selectedFolder) {
                    app.setUserSettingsValue(RECENT_FOLDER_KEY, selectedFolder);
                }
            }
        });

    } }); // class SaveAsTemplateDialog

    // exports ================================================================

    return SaveAsTemplateDialog;

});
