/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/control/borderwidthpicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/combofield',
    'io.ox/office/editframework/view/editlabels',
    'gettext!io.ox/office/editframework/main'
], function (Utils, ComboField, Labels, gt) {

    'use strict';

    // class BorderWidthPicker ================================================

    /**
     * A combo field with predefined entries for border line widths, in points.
     *
     * @constructor
     *
     * @extends ComboField
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options supported by the base class
     *  ComboField.
     */
    function BorderWidthPicker(docView, initOptions) {

        // base constructor ---------------------------------------------------

        initOptions = Utils.extendOptions({
            width: 40,
            tooltip: Labels.BORDER_WIDTH_LABEL,
            style: 'text-align:right;',
            keyboard: 'number',
            validator: new ComboField.NumberValidator({ min: 0.5, max: 10, precision: 0.1 }),
            dropDownVersion: { label: Labels.BORDER_WIDTH_LABEL }
        }, initOptions);

        ComboField.call(this, docView, Utils.extendOptions({
            dropDownVersion: { label: Utils.getStringOption(initOptions, 'tooltip') }
        }, initOptions));

        // initialization -----------------------------------------------------

        [0.5, 1, 1.5, 2, 2.5, 3, 4, 6].forEach(function (size) {
            this.createListEntry(size, {
                //#. A single list entry of a GUI border width picker.
                //#. Example result: "5 points"
                //#. %1$d is the width of the border line.
                //#, c-format
                label: gt.npgettext('borders', '%1$d point', '%1$d points', size, _.noI18n(size)),
                style: 'text-align:center;'
            });
        }, this);

    } // class BorderWidthPicker

    // exports ================================================================

    // derive this class from class ComboField
    return ComboField.extend({ constructor: BorderWidthPicker });

});
