/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/control/compoundmenumixin', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/menumixin',
    'io.ox/office/baseframework/view/popup/compoundmenu'
], function (Utils, MenuMixin, CompoundMenu) {

    'use strict';

    // class CompoundMenuMixin ================================================

    /**
     * A mix-in class for control groups that adds a drop-down button with a
     * complete self-contained view component instance with completely
     * independent controls in its drop-down menu.
     *
     * Note: This is a mix-in class supposed to extend an existing instance of
     * the class Group or one of its derived classes. Expects the symbol 'this'
     * to be bound to an initialized instance of Group (this mix-in constructor
     * MUST be called after the Group constructor).
     *
     * @constructor
     *
     * @extends MenuMixin
     *
     * @param {BaseView} docView
     *  The document view instance containing this control.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options also supported by the base
     *  class MenuMixin (visibility of caret icon), and the class CompoundMenu
     *  (settings for the drop-down menu).
     */
    function CompoundMenuMixin(docView, initOptions) {

        var // the pop-up menu instance
            menu = new CompoundMenu(docView, Utils.extendOptions({ expandWidth: true }, initOptions, { anchor: this.getNode() }));

        // base constructors --------------------------------------------------

        MenuMixin.call(this, menu, initOptions);

        // public methods -----------------------------------------------------

        // export methods of the menu
        ['addGroup', 'removeGroup', 'addSeparator', 'addSectionLabel'].forEach(function (methodName) {
            this[methodName] = function () {
                var result = menu[methodName].apply(menu, arguments);
                return (result === menu) ? this : result;
            };
        }, this);

        // initialization -----------------------------------------------------

        // destroy all class members
        this.registerDestructor(function () {
            docView = initOptions = menu = null;
        });

    } // class CompoundMenuMixin

    // exports ================================================================

    // derive this class from class MenuMixin
    return MenuMixin.extend({ constructor: CompoundMenuMixin });

});
