/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.DefaultArchiveRemover;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.io.File;
import java.util.Date;

public class TimeBasedArchiveRemover
extends DefaultArchiveRemover {
    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        super(fileNamePattern, rc);
    }

    @Override
    protected void cleanByPeriodOffset(Date now, int periodOffset) {
        Date fileLastModified;
        Date date2delete = this.rc.getEndOfNextNthPeriod(now, periodOffset);
        String filename = this.fileNamePattern.convert(date2delete);
        File file2Delete = new File(filename);
        if (file2Delete.exists() && file2Delete.isFile() && (fileLastModified = this.rc.getEndOfNextNthPeriod(new Date(file2Delete.lastModified()), -1)).compareTo(date2delete) <= 0) {
            this.addInfo("deleting " + file2Delete);
            file2Delete.delete();
            if (this.parentClean) {
                this.removeFolderIfEmpty(file2Delete.getParentFile());
            }
        }
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }
}

