/*
 * Decompiled with CFR 0.152.
 */
package org.ho.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class DateTimeParser
extends DateFormat {
    public static final String DATEFORMAT_ISO8601 = "yyyy-MM-dd'T'hh:mm:ss.SSS'Z'";
    public static final String DATEFORMAT_YAML = "yyyy-MM-dd hh:mm:ss";
    private static final String DATEFORMAT_TOSTRING = "EEE MMM dd hh:mm:ss z yyyy";
    private static final int FORMAT_NONE = -1;
    protected SimpleDateFormat outputFormat;
    protected ArrayList<Parser> parsers = new ArrayList();

    public DateTimeParser() {
        this.outputFormat = new SimpleDateFormat(DATEFORMAT_ISO8601);
        this.setupParsers();
    }

    public DateTimeParser(String string) {
        this.outputFormat = new SimpleDateFormat(string);
        this.setupParsers();
    }

    protected void setupParsers() {
        this.parsers.clear();
        this.parsers.add(new SimpleParser(this.outputFormat));
        this.parsers.add(new Parser(){

            public Date parse(String string) throws ParseException {
                try {
                    long l = Long.parseLong(string);
                    return new Date(l);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Error parsing value", -1);
                }
            }
        });
        this.parsers.add(new SimpleParser("yyyy-MM-dd"));
        this.parsers.add(new SimpleParser(DATEFORMAT_TOSTRING));
        this.parsers.add(new SimpleParser(0, 0));
        this.parsers.add(new SimpleParser(1, 1));
        this.parsers.add(new SimpleParser(2, 2));
        this.parsers.add(new SimpleParser(3, 3));
        this.parsers.add(new SimpleParser(0, -1));
        this.parsers.add(new SimpleParser(1, -1));
        this.parsers.add(new SimpleParser(2, -1));
        this.parsers.add(new SimpleParser(3, -1));
        this.parsers.add(new SimpleParser(-1, 0));
        this.parsers.add(new SimpleParser(-1, 1));
        this.parsers.add(new SimpleParser(-1, 2));
        this.parsers.add(new SimpleParser(-1, 3));
    }

    public void addParser(Parser parser) {
        this.parsers.add(parser);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        String string2 = string.substring(parsePosition.getIndex());
        Date date = null;
        for (Parser parser : this.parsers) {
            try {
                date = parser.parse(string2);
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (date == null) {
            parsePosition.setIndex(parsePosition.getIndex());
            parsePosition.setErrorIndex(parsePosition.getIndex());
        } else {
            parsePosition.setIndex(string2.length());
        }
        return date;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.outputFormat.format(date, stringBuffer, fieldPosition);
    }

    protected class SimpleParser
    implements Parser {
        private DateFormat fmt;

        public SimpleParser(String string) {
            this.fmt = new SimpleDateFormat(string);
        }

        public SimpleParser(DateFormat dateFormat) {
            this.fmt = dateFormat;
        }

        public SimpleParser(int n, int n2) {
            this.fmt = n2 < 0 ? DateFormat.getDateInstance(n) : (n < 0 ? DateFormat.getTimeInstance(n2) : DateFormat.getDateTimeInstance(n, n2));
        }

        public Date parse(String string) throws ParseException {
            return this.fmt.parse(string);
        }
    }

    protected static interface Parser {
        public Date parse(String var1) throws ParseException;
    }
}

