/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.ListFileMembersCountResult;
import com.dropbox.core.v2.sharing.SharingFileAccessError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ListFileMembersIndividualResult {
    public static final ListFileMembersIndividualResult OTHER = new ListFileMembersIndividualResult(Tag.OTHER, null, null);
    private final Tag _tag;
    private final ListFileMembersCountResult resultValue;
    private final SharingFileAccessError accessErrorValue;

    private ListFileMembersIndividualResult(Tag _tag, ListFileMembersCountResult resultValue, SharingFileAccessError accessErrorValue) {
        this._tag = _tag;
        this.resultValue = resultValue;
        this.accessErrorValue = accessErrorValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isResult() {
        return this._tag == Tag.RESULT;
    }

    public static ListFileMembersIndividualResult result(ListFileMembersCountResult value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ListFileMembersIndividualResult(Tag.RESULT, value, null);
    }

    public ListFileMembersCountResult getResultValue() {
        if (this._tag != Tag.RESULT) {
            throw new IllegalStateException("Invalid tag: required Tag.RESULT, but was Tag." + this._tag.name());
        }
        return this.resultValue;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static ListFileMembersIndividualResult accessError(SharingFileAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ListFileMembersIndividualResult(Tag.ACCESS_ERROR, null, value);
    }

    public SharingFileAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.resultValue, this.accessErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListFileMembersIndividualResult) {
            ListFileMembersIndividualResult other = (ListFileMembersIndividualResult)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case RESULT: {
                    return this.resultValue == other.resultValue || this.resultValue.equals(other.resultValue);
                }
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ListFileMembersIndividualResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListFileMembersIndividualResult value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case RESULT: {
                    g.writeStartObject();
                    this.writeTag("result", g);
                    ListFileMembersCountResult.Serializer.INSTANCE.serialize(value.resultValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case ACCESS_ERROR: {
                    g.writeStartObject();
                    this.writeTag("access_error", g);
                    g.writeFieldName("access_error");
                    SharingFileAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public ListFileMembersIndividualResult deserialize(JsonParser p) throws IOException, JsonParseException {
            ListFileMembersIndividualResult value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("result".equals(tag)) {
                ListFileMembersCountResult fieldValue = null;
                fieldValue = ListFileMembersCountResult.Serializer.INSTANCE.deserialize(p, true);
                value = ListFileMembersIndividualResult.result(fieldValue);
            } else if ("access_error".equals(tag)) {
                SharingFileAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = SharingFileAccessError.Serializer.INSTANCE.deserialize(p);
                value = ListFileMembersIndividualResult.accessError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        RESULT,
        ACCESS_ERROR,
        OTHER;

    }
}

