/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations;

import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapValue;
import com.hazelcast.multimap.impl.operations.MultiMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.Collection;

public abstract class MultiMapKeyBasedOperation
extends MultiMapOperation
implements PartitionAwareOperation {
    protected Data dataKey;
    protected long threadId;

    protected MultiMapKeyBasedOperation() {
    }

    protected MultiMapKeyBasedOperation(String name, Data dataKey) {
        super(name);
        this.dataKey = dataKey;
    }

    protected MultiMapKeyBasedOperation(String name, Data dataKey, long threadId) {
        super(name);
        this.dataKey = dataKey;
        this.threadId = threadId;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public final MultiMapValue getOrCreateMultiMapValue() {
        return this.getOrCreateContainer().getOrCreateMultiMapValue(this.dataKey);
    }

    public final MultiMapValue getMultiMapValueOrNull() {
        MultiMapContainer container = this.getOrCreateContainer();
        return container.getMultiMapValueOrNull(this.dataKey);
    }

    public final Collection<MultiMapRecord> remove(boolean copyOf) {
        return this.getOrCreateContainer().remove(this.dataKey, copyOf);
    }

    public final void delete() {
        this.getOrCreateContainer().delete(this.dataKey);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.threadId);
        out.writeData(this.dataKey);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.threadId = in.readLong();
        this.dataKey = in.readData();
    }
}

