/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.nearcache.impl.record;

import com.hazelcast.cache.impl.nearcache.NearCacheRecord;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractNearCacheRecord<V>
implements NearCacheRecord<V> {
    private static final AtomicIntegerFieldUpdater<AbstractNearCacheRecord> ACCESS_HIT = AtomicIntegerFieldUpdater.newUpdater(AbstractNearCacheRecord.class, "accessHit");
    protected V value;
    protected long creationTime = -1L;
    protected volatile long expirationTime = -1L;
    protected volatile long accessTime = -1L;
    protected volatile int accessHit;

    public AbstractNearCacheRecord(V value, long creationTime, long expirationTime) {
        this.value = value;
        this.creationTime = creationTime;
        this.expirationTime = expirationTime;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.accessTime;
    }

    @Override
    public void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    @Override
    public int getAccessHit() {
        return this.accessHit;
    }

    @Override
    public void setAccessHit(int accessHit) {
        ACCESS_HIT.set(this, accessHit);
    }

    @Override
    public void incrementAccessHit() {
        ACCESS_HIT.addAndGet(this, 1);
    }

    @Override
    public void resetAccessHit() {
        ACCESS_HIT.set(this, 0);
    }

    @Override
    public boolean isExpiredAt(long now) {
        return this.expirationTime > -1L && this.expirationTime <= now;
    }

    @Override
    public boolean isIdleAt(long maxIdleMilliSeconds, long now) {
        if (maxIdleMilliSeconds > 0L) {
            if (this.accessTime > -1L) {
                return this.accessTime + maxIdleMilliSeconds < now;
            }
            return this.creationTime + maxIdleMilliSeconds < now;
        }
        return false;
    }
}

