/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationexecutor.classic;

import com.hazelcast.spi.impl.operationexecutor.classic.ScheduleQueue;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public final class DefaultScheduleQueue
implements ScheduleQueue {
    static final Object TRIGGER_TASK = new Object(){

        public String toString() {
            return "triggerTask";
        }
    };
    private final BlockingQueue normalQueue;
    private final ConcurrentLinkedQueue priorityQueue;

    public DefaultScheduleQueue() {
        this(new LinkedBlockingQueue(), new ConcurrentLinkedQueue());
    }

    public DefaultScheduleQueue(BlockingQueue normalQueue, ConcurrentLinkedQueue priorityQueue) {
        this.normalQueue = Preconditions.checkNotNull(normalQueue, "normalQueue");
        this.priorityQueue = Preconditions.checkNotNull(priorityQueue, "priorityQueue");
    }

    @Override
    public void add(Object task) {
        Preconditions.checkNotNull(task, "task can't be null");
        this.normalQueue.add(task);
    }

    @Override
    public void addUrgent(Object task) {
        Preconditions.checkNotNull(task, "task can't be null");
        this.priorityQueue.add(task);
        this.normalQueue.add(TRIGGER_TASK);
    }

    @Override
    public int normalSize() {
        return this.normalQueue.size();
    }

    @Override
    public int prioritySize() {
        return this.priorityQueue.size();
    }

    @Override
    public int size() {
        return this.normalQueue.size() + this.priorityQueue.size();
    }

    @Override
    public Object take() throws InterruptedException {
        Object normalItem;
        ConcurrentLinkedQueue priorityQueue = this.priorityQueue;
        do {
            Object priorityItem;
            if ((priorityItem = priorityQueue.poll()) == null) continue;
            return priorityItem;
        } while ((normalItem = this.normalQueue.take()) == TRIGGER_TASK);
        return normalItem;
    }
}

